<?php

namespace App\Http\Responses\Focus\productconversion;

use Illuminate\Contracts\Support\Responsable;

use App\Models\product\Product;

class EditResponse implements Responsable
{

    protected $product_conversion;

    public function __construct($product_conversion)
    {
        $this->product_conversion = $product_conversion;
    }

    public function toResponse($request)
    {
        $products = Product::all();
        return view('focus.productconversion.edit')->with([
            'products' => $products,
            'productconversion' => $this->product_conversion
        ]);
    }
}
