<?php

namespace App\Http\Responses\Focus\purchaseorder;

use App\Models\additional\Additional;
use App\Models\pricegroup\Pricegroup;
use App\Models\purchaseorder\Purchaseorder;
use App\Models\supplier\Supplier;
use App\Models\term\Term;
use App\Models\currency\Currency;
use Illuminate\Contracts\Support\Responsable;
use App\Models\purchase_request\PurchaseRequestItem;

class CreateResponse implements Responsable
{
    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $ins = auth()->user()->ins;
        $prefixes = prefixesArray(['purchase_order'], $ins);
        $last_tid = Purchaseorder::where('ins', $ins)->max('tid');

        $additionals = Additional::all();
        $pricegroups = Pricegroup::all();
        $supplier = Supplier::where('name', 'Walk-in')->first(['id', 'name']);
        $price_supplier = Supplier::whereHas('products')->get(['id', 'name']);
        $items = PurchaseRequestItem::where(['status_check'=>'1','purchase_type'=>'purchase_order','requisition_item_type'=>'paper'])->whereHas('product')->get();
        $grouped_items = $items->groupBy(['item_id']);
        $products = [];
        foreach ($grouped_items as $item => $val) {
            $total_qty = $val->sum('qty');
            //dd($val->first());
            $products[] = [
                'name' => @$val->first()->name,
                'sku' => @$val->first()->sku,
                'uom' => @$val->first()->uom,
                'item_id' => @$val->first()->item_id,
                'purchase_price' => $val->first()->product ? $val->first()->product->purchase_price :'',
                'qty' => $total_qty,
            ];
        }
        // Purchase order
        $terms = Term::where('type', 4)->get();
        $currency = Currency::all();

        return view('focus.purchaseorders.create', compact('last_tid', 'additionals', 'pricegroups','price_supplier', 'terms', 'prefixes','products','currency'));
    }
}
