<?php

namespace App\Http\Responses\Focus\question;

use Illuminate\Contracts\Support\Responsable;
use App\Models\process\Process;

class EditResponse implements Responsable
{
    /**
     * @var App\Models\question\question
     */
    protected $questions;

    /**
     * @param App\Models\question\question $questions
     */
    public function __construct($questions)
    {
        $this->questions = $questions;
    }

    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $processes = Process::all(['id', 'process_name']);
        return view('focus.questions.edit')->with([
            'questions' => $this->questions,
            'processes' => $processes
        ]);
    }
}