<?php

namespace App\Http\Responses\Focus\request_dispatch;

use Illuminate\Contracts\Support\Responsable;
use App\Models\customer\Customer;

class EditResponse implements Responsable
{
    /**
     * @var App\Models\request_dispatch\request_dispatch
     */
    protected $request_dispatchs;

    /**
     * @param App\Models\request_dispatch\request_dispatch $request_dispatchs
     */
    public function __construct($request_dispatchs)
    {
        $this->request_dispatchs = $request_dispatchs;
    }

    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $customers = Customer::all(['id','company']);
        return view('focus.request_dispatchs.edit', compact('customers'))->with([
            'request_dispatchs' => $this->request_dispatchs
        ]);
    }
}