<?php

namespace App\Http\Responses\Focus\request_quotation;

use Illuminate\Contracts\Support\Responsable;
use App\Models\supplier\Supplier;
use App\Models\term\Term;
use App\Models\request_quotation\RequestQuotation;

class CreateResponse implements Responsable
{
    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $suppliers = Supplier::all(['id', 'name']);
        $terms = Term::where('type', 1)->get();
        $tid = RequestQuotation::where('ins', auth()->user()->ins)->max('tid');
        return view('focus.request_quotations.create', compact('suppliers', 'terms', 'tid'));
    }
}