<?php

namespace App\Http\Responses\Focus\request_quotation;

use Illuminate\Contracts\Support\Responsable;
use App\Models\supplier\Supplier;
use App\Models\term\Term;

class EditResponse implements Responsable
{
    /**
     * @var App\Models\request_quotation\request_quotation
     */
    protected $request_quotations;

    /**
     * @param App\Models\request_quotation\request_quotation $request_quotations
     */
    public function __construct($request_quotations)
    {
        $this->request_quotations = $request_quotations;
    }

    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $suppliers = Supplier::all(['id', 'name']);
        $terms = Term::where('type', 1)->get();
        return view('focus.request_quotations.edit', compact('suppliers', 'terms'))->with([
            'request_quotations' => $this->request_quotations
        ]);
    }
}