<?php

namespace App\Http\Responses\Focus\waste_management;

use App\Models\assembly\assembly_station\AssemblyStation;
use Illuminate\Contracts\Support\Responsable;
use App\Models\warehouse\Warehouse;
use App\Models\product\Product;
use App\Models\productvariable\Productvariable;
use App\Models\waste_management\WasteManagement;

class CreateResponse implements Responsable
{
    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $ins = auth()->user()->ins;
        $warehouses = Warehouse::where('ins', $ins)->get();
        $stations = AssemblyStation::all();
        $products = Product::all();
        $productvariables = Productvariable::all();
        $waste_entries_count = WasteManagement::count();

        return view('focus.waste_management.create', compact('warehouses','stations','products','productvariables','waste_entries_count'));
    }
}
