<?php

namespace App\Http\Responses\Focus\waste_management;

use Illuminate\Contracts\Support\Responsable;
use DB;
use App\Models\assembly\assembly_station\AssemblyStation;
use App\Models\warehouse\Warehouse;
use App\Models\product\Product;
use App\Models\productvariable\Productvariable;
use App\Models\waste_management\WasteManagement;

class EditResponse implements Responsable
{
    protected $waste_management;

    public function __construct($waste_management)
    {
        $this->waste_management = $waste_management;
    }

    public function toResponse($request)
    {
        $ins = auth()->user()->ins;
        $warehouses = Warehouse::where('ins', $ins)->get();
        $stations = AssemblyStation::all();
        $products = Product::all();
        $productvariables = Productvariable::all();
        $waste_entries_count = WasteManagement::count();
        return view('focus.waste_management.edit', compact('warehouses','stations','products','productvariables','waste_entries_count'))->with(['waste_management' => $this->waste_management]);
    }
}
