<?php

namespace App\Models\account\Traits;

use App\Models\account\Account;

/**
 * Class AccountAttribute.
 */
trait AccountAttribute
{
    // Make your attributes functions here
    // Further, see the documentation : https://laravel.com/docs/5.4/eloquent-mutators#defining-an-accessor


    /**
     * Action Button Attribute to show in grid
     * 
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return '
         '.$this->getViewButtonAttribute("manage-account", "biller.accounts.show").'
                '.$this->getEditButtonAttribute("edit-account", "biller.accounts.edit").'
                '.$this->getDeleteButtonAttribute("delete-account", "biller.accounts.destroy").'
                ';
    }

    /**
     * Debit Total
     * 
     * @return string
     */
    public function getDebitTotalAttribute()
    {
        return $this->transactions()->sum('debit');
    }

    /**
     * Credit Total
     * 
     * @return string
     */
    public function getCreditTotalAttribute()
    {
        return $this->transactions()->sum('credit');
    }

    /**
     * Subledger system
     * 
     */
    public function getSystemAttribute($value)
    {
        if ($this->ledger_id) {
            $main_account = Account::find($this->ledger_id);
            return @$main_account->system;         
        }
        return $value;
    }

    /**
     * Subledger Accounts
     * 
     */
    public function getSubledgerAccountsAttribute()
    {
        if ($this->ledger_id) return collect();
        return Account::where('ledger_id', $this->id)->get();
    }
}
