<?php

namespace App\Models\assembly\assembled_product;

use App\Models\assembly\assembled_product\Traits\AssembledProductAttribute;
use App\Models\assembly\assembled_product\Traits\AssembledProductRelationship;
use Illuminate\Database\Eloquent\Model;
use App\Models\ModelTrait;

class AssembledProduct extends Model
{
    use ModelTrait, AssembledProductAttribute , AssembledProductRelationship;

    protected $table = 'assembled_products';

    protected $fillable = [
        'tid','entry_no','warehouse_id','assemble_date', 'notes', 'user_id', 'ins'
    ];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];
    protected $guarded = [
        'id'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}

