<?php

namespace App\Models\assembly\assembly_station;

use App\Models\assembly\assembly_station\Traits\AssemblyStationAttribute;
use App\Models\assembly\assembly_station\Traits\AssemblyStationRelationship;
use Illuminate\Database\Eloquent\Model;
use App\Models\ModelTrait;


class AssemblyStation extends Model
{
    use ModelTrait, AssemblyStationAttribute, AssemblyStationRelationship;

    protected $table = 'assembly_stations';

    protected $fillable = [
        'tid','name', 'description', 'user_id', 'ins'
    ];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];
    protected $guarded = [
        'id'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}
