<?php

namespace App\Models\banktransfer\Traits;

use App\Models\account\Account;
use App\Models\transaction\Transaction;
use App\Models\transaction\TransactionOrigin;

/**
 * Class TransactionRelationship
 */
trait BanktransferRelationship
{
    public function credit_account()
    {
        return $this->belongsTo(Account::class, 'credit_ledger_id');
    }

    public function debit_account()
    {
        return $this->belongsTo(Account::class, 'debit_ledger_id');
    }

    public function transactions()
    {
        return $this->hasManyThrough(Transaction::class, TransactionOrigin::class, 'bank_transfer_id', 'id', 'id', 'journal_entry_id')
            ->withoutGlobalScopes();
    }

    public function transaction_origins()
    {
        return $this->hasMany(TransactionOrigin::class, 'bank_transfer_id');
    }
}
