<?php

namespace App\Models\charge\Traits;

use App\Models\transaction\Transaction;
use App\Models\transaction\TransactionOrigin;

trait ChargeRelationship
{
    public function account()
    {
        return $this->belongsTo('App\Models\account\Account', 'ledger_id');
    }

    public function transactions()
    {
        return $this->hasManyThrough(Transaction::class, TransactionOrigin::class, 'charge_id', 'id', 'id', 'journal_entry_id')
            ->withoutGlobalScopes();
    }

    public function transaction_origins()
    {
        return $this->hasMany(TransactionOrigin::class, 'charge_id');
    }
}
