<?php

namespace App\Models\creditnote;

use App\Models\creditnote\Traits\CreditNoteAttribute;
use App\Models\creditnote\Traits\CreditNoteRelationship;
use App\Models\ModelTrait;
use Illuminate\Database\Eloquent\Model;

class CreditNote extends Model
{
    use ModelTrait, CreditNoteAttribute, CreditNoteRelationship;

    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'payments';

    /**
     * Mass Assignable fields of model
     * @var array
     */
    protected $fillable = [];

    /**
     * Default values for model fields
     * @var array
     */
    protected $attributes = [];

    /**
     * Dates
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    /**
     * Guarded fields of model
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($creditnote) {
            $creditnote->fill([
                'type' => 'creditnote',
                'tid' => CreditNote::max('tid')+1,
                'user_id' => auth()->user()->id,
                'ins' => auth()->user()->ins,
            ]);

            return $creditnote;
        });

        static::addGlobalScope(function ($builder) {
            $builder->where('type', 'creditnote');
        });
        
        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', auth()->user()->ins);
        });
    }    
}
