<?php

namespace App\Models\creditnote\Traits;

use App\Models\customer\Customer;
use App\Models\invoice\Invoice;
use App\Models\items\CreditNoteItem;
use App\Models\transaction\Transaction;
use App\Models\transaction\TransactionOrigin;

trait DebitNoteRelationship
{
    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    public function supplier()
    {
        return $this->belongsTo(Customer::class);
    }

    public function items()
    {
        return $this->hasMany(CreditNoteItem::class, 'payment_id');
    }

    public function transactions()
    {
        return $this->hasManyThrough(Transaction::class, TransactionOrigin::class, 'payment_id', 'id', 'id', 'journal_entry_id')
            ->withoutGlobalScopes();
    }

    public function transaction_origins()
    {
        return $this->hasMany(TransactionOrigin::class, 'payment_id');
    }
}