<?php

namespace App\Models\debitnote;

use App\Models\debitnote\Traits\DebitNoteAttribute;
use App\Models\debitnote\Traits\DebitNoteRelationship;
use App\Models\ModelTrait;
use Illuminate\Database\Eloquent\Model;

class DebitNote extends Model
{
    use ModelTrait, DebitNoteAttribute, DebitNoteRelationship;

    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'payments';

    /**
     * Mass Assignable fields of model
     * @var array
     */
    protected $fillable = [];

    /**
     * Default values for model fields
     * @var array
     */
    protected $attributes = [];

    /**
     * Dates
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    /**
     * Guarded fields of model
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($debitnote) {
            $debitnote->fill([
                'type' => 'debitnote',
                'tid' => DebitNote::max('tid')+1,
                'user_id' => auth()->user()->id,
                'ins' => auth()->user()->ins,
            ]);

            return $debitnote;
        });

        static::addGlobalScope(function ($builder) {
            $builder->where('type', 'debitnote');
        });
        
        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', auth()->user()->ins);
        });
    }    
}
