<?php

namespace App\Models\invoice\Traits;

use App\Models\invoice\Invoice;

/**
 * Class InvoiceAttribute.
 */
trait InvoiceAttribute
{
    // Make your attributes functions here
    // Further, see the documentation : https://laravel.com/docs/5.4/eloquent-mutators#defining-an-accessor


    /**
     * Action Button Attribute to show in grid
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return $this->getViewButtonAttribute("manage-invoice", "biller.invoices.show");
            // . ' ' . $this->getEditButtonAttribute("invoice-edit", "biller.invoices.index") 
            // . ' ' . $this->getDeleteButtonAttribute("delete-invoice", "biller.invoices.destroy");
    }


    /**
     * Next Transaction ID code
     * 
     * @return float
     */
    public function getNextTidCodeAttribute()
    {
        $tid = Invoice::max('tid');
        return gen4tid('INV-', $tid);
    }


    /**
     * Transaction ID code
     * 
     * @return float
     */
    public function getTidCodeAttribute()
    {
        return gen4tid('INV-', $this->tid);
    }

    /**
     * Invoice amount received
     * 
     * @return float
     */
    public function getAmountReceivedAttribute()
    {
        return +$this->payments()->sum('amount');
    }

    /**
     * Invoice Status
     * 
     * @return float
     */
    public function getStatusAttribute()
    {
        $status = 'due';
        $amount_due = round($this->total);
        $amount_received = round($this->getAmountReceivedAttribute());
        if ($amount_received > 0 && $amount_received < $amount_due) $status = 'partial';
        if ($amount_received >= $amount_due) $status = 'paid';
        
        return $status;
    }

    /**
     * Allocated Opening balance
     */
    public function getIsAllocatedOpeningBalanceAttribute()
    {
        return $this->payments()->whereNotNull('payment_id')->exists();
    }
}
