<?php

namespace App\Models\invoice_payment\Traits;

use App\Models\invoice_payment\InvoicePayment;

/**
 * Class InvoiceAttribute.
 */
trait InvoicePaymentAttribute
{
    /**
     * Action Button Attribute to show in grid
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return $this->getViewButtonAttribute("manage-invoice", "biller.invoice_payments.show")
            . ' ' . $this->getEditButtonAttribute("edit-invoice", "biller.invoice_payments.edit") 
            . ' ' . $this->getDeleteButtonAttribute("delete-invoice", "biller.invoice_payments.destroy");
    }

    /**
     * Transaction ID code
     * 
     * @return float
     */
    public function getTidCodeAttribute()
    {
        return gen4tid('DEPO-', $this->tid);
    }

    /**
     * Payment credit balance
     * 
     * @return float
     */
    public function getCreditAppliedAttribute()
    {
        return (float) InvoicePayment::where('credit_id', $this->id)->sum('allocated_total');
    }
}
