<?php

namespace App\Models\invoice_payment\Traits;

use App\Models\account\Account;
use App\Models\customer\Customer;
use App\Models\items\InvoicePaymentItem;
use App\Models\transaction\Transaction;
use App\Models\transaction\TransactionOrigin;

trait InvoicePaymentRelationship
{
    public function account()
    {
        return $this->belongsTo(Account::class, 'ledger_id');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function items()
    {
        return $this->hasMany(InvoicePaymentItem::class, 'payment_id');
    }

    public function transactions()
    {
        return $this->hasManyThrough(Transaction::class, TransactionOrigin::class, 'payment_id', 'id', 'id', 'journal_entry_id')
            ->withoutGlobalScopes();
    }

    public function transaction_origins()
    {
        return $this->hasMany(TransactionOrigin::class, 'payment_id');
    }
}
