<?php

namespace App\Models\productconversion;

use Illuminate\Database\Eloquent\Model;
use App\Models\ProductConversion\ProductConversion;

class ProductConversionRawMaterials extends Model
{
    protected $table = 'product_conversion_raw_materials';

    protected $fillable =[
        'product_conversion_id',
        'raw_material',
        'raw_material_quantity'
    ];
    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];

    protected $guarded = [
        'id'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }

    public function product_conversion(){
        return $this->belongsTo(ProductConversion::class);
    }

}
