<?php

namespace App\Models\quote;

use App\Models\ModelTrait;
use Illuminate\Database\Eloquent\Model;
use App\Models\quote\Traits\QuoteAttribute;
use App\Models\quote\Traits\QuoteRelationship;

class Quote extends Model
{
    use ModelTrait,
        QuoteAttribute,
        QuoteRelationship;


    /**
     * NOTE : If you want to implement Soft Deletes in this model,
     * then follow the steps here : https://laravel.com/docs/5.4/eloquent#soft-deleting
     */

    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'quotes';

    /**
     * Mass Assignable fields of model
     * @var array
     */
    protected $fillable = [];

    /**
     * Default values for model fields
     * @var array
     */
    protected $attributes = [];

    /**
     * Dates
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    /**
     * Guarded fields of model
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Constructor of Model
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
        parent::boot();
        static::addGlobalScope('ins', function ($builder) {
            $builder->where(function($query){
                $query->where('ins','=',@auth()->user()->ins)->orWhere('ins','=',@auth('crm')->user()->ins);
            });
        });
        static::creating(function ($instance) {
            $instance->fill([
                'user_id' => auth()->user()->id,
                'ins' => auth()->user()->ins,
                'tid' => Quote::getTid() + 1,
            ]);
            return $instance;
        });
    }
    static function getTid()
    {
        return Quote::where('ins', auth()->user()->ins)->max('tid');
    }
}
