<?php

namespace App\Models\request_dispatch\Traits;

use App\Models\hrm\Hrm;
use App\Models\hrm\HrmMeta;
use App\Models\request_dispatch\RequestDispatchItem;
use App\Models\customer\Customer;
use App\Models\delivery_note\DeliveryNote;

/**
 * Class RequestDispatchRelationship
 */
trait RequestDispatchRelationship
{
     public function items()
     {
        return $this->hasMany(RequestDispatchItem::class);
     }

     public function customer()
     {
        return $this->belongsTo(Customer::class, 'customer_id');
     }
     public function delivery()
    {
        return $this->hasOne(DeliveryNote::class);
    }
}
