<?php

namespace App\Models\shops;

use Illuminate\Database\Eloquent\Model;
use App\Models\ModelTrait;
use App\Models\shops\Traits\ShopAttribute;
use App\Models\shops\Traits\ShopRelationship;

class Shop extends Model
{
    use ModelTrait, ShopAttribute, ShopRelationship;

    protected $table = 'shops';

    protected $fillable = [
        'name','code','description','user_id', 'ins'
    ];

    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];
    protected $guarded = [
        'id'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}
