<?php

namespace App\Models\stock_adjustment;

use App\Models\ModelTrait;
use App\Models\stock_adjustment\Traits\StockAdjustmentAttribute;
use App\Models\stock_adjustment\Traits\StockAdjustmentRelationship;
use Illuminate\Database\Eloquent\Model;

class StockAdjustment extends Model
{
    use ModelTrait, StockAdjustmentRelationship, StockAdjustmentAttribute;
    protected $table = 'stock_adjustments';

    protected $fillable = [

    ];
    protected $attributes = [];

    protected $dates = [
        'created_at',
        'updated_at'
    ];

    protected $guarded = [
        'id'
    ];


    public function __construct(array $attributes = [])
        {
            parent::__construct($attributes);
        }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($instance) {
            $instance->ins = auth()->user()->ins;
            return $instance;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', '=', auth()->user()->ins);
        });
    }
}
