<?php

namespace App\Models\supplier;

use App\Models\ModelTrait;
use Illuminate\Database\Eloquent\Model;
use App\Models\supplier\Traits\SupplierAttribute;
use App\Models\supplier\Traits\SupplierRelationship;

class Supplier extends Model
{
    use ModelTrait,
        SupplierAttribute,
        SupplierRelationship {
        // SupplierAttribute::getEditButtonAttribute insteadof ModelTrait;
    }

    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'customers';

    /**
     * Mass Assignable fields of model
     * @var array
     */
    protected $fillable = [];

    /**
     * Default values for model fields
     * @var array
     */
    protected $attributes = [];

    /**
     * Dates
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    /**
     * Guarded fields of model
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Constructor of Model
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    /**
     * model life cycle event listeners
     * @return void
     */
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($supplier) {
            $tid = Supplier::where('user_type', $supplier->user_type)->max('tid');
            $supplier->tid = $tid+1;
            return $supplier;
        });

        static::saving(function ($supplier) {
            $supplier->fill([
                'user_id' => auth()->user()->id,
                'ins' => auth()->user()->ins,
            ]);
            return $supplier;
        });

        static::addGlobalScope('user_type', function ($builder) {
            $builder->where('user_type', 'supplier');
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins',  auth()->user()->ins);
        });
    }

    public function getPictureAttribute()
    {
        return $this->attributes['picture'] ?: 'example.png';
    }
}
