<?php

namespace App\Models\supplier\Traits;

use App\Models\items\BillpaymentItem;

/**
 * Class SupplierAttribute.
 */
trait SupplierAttribute
{
    // Make your attributes functions here
    // Further, see the documentation : https://laravel.com/docs/5.4/eloquent-mutators#defining-an-accessor


    /**
     * Action Button Attribute to show in grid
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return '
         '.$this->getViewButtonAttribute("manage-supplier", "biller.suppliers.show").'
                '.$this->getEditButtonAttribute("edit-supplier", "biller.suppliers.edit").'
                '.$this->getDeleteButtonAttribute("delete-supplier", "biller.suppliers.destroy").'
                ';
    }

    /**
     * On Account Balance
     * 
     * @return string
     */
    public function getOnAccountBalanceAttribute()
    {
        $overpayment = BillpaymentItem::whereNull('invoice_id')
            ->whereHas('payment', fn($q) => $q->where('supplier_id', $this->id))
            ->sum('amount');
        $overpayment_allocations = BillpaymentItem::whereNotNull('item_payment_id')
            ->whereHas('payment', fn($q) => $q->where('supplier_id', $this->id))
            ->sum('amount');
        return $overpayment - $overpayment_allocations;
    }
}
