<?php

namespace App\Models\transaction\Traits;

use App\Models\transaction\Transaction;

/**
 * Class TransactionAttribute.
 */
trait TransactionAttribute
{
    // Make your attributes functions here
    // Further, see the documentation : https://laravel.com/docs/5.4/eloquent-mutators#defining-an-accessor


    /**
     * Action Button Attribute to show in grid
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return $this->getViewButtonAttribute("manage-account", "biller.transactions.show"); 
    }

    /**
     * Transaction Group balance
     * 
     * @return string
     */
    public function getGroupBalanceAttribute()
    {
        return Transaction::selectRaw('SUM(debit-credit) as balance')->where('tid', $this->tid)->first()->balance;
    }

    /**
     * Transaction Type
     * 
     * @return string
     */
    public function getOriginTypeAttribute()
    {
        $type = '';
        if ($this->manual_journal) $type = 'manual_journal';
        if ($this->invoice) $type = 'invoice';
        if ($this->deposit) $type = 'deposit';
        if ($this->creditnote) $type = 'credit_note';
        if ($this->bill) $type = 'bill';
        if ($this->payment) $type = 'payment';

        return $type;
    }
}
