<?php

namespace App\Models\transaction;

use App\Models\transaction\Traits\TransactionOriginRelationship;
use Illuminate\Database\Eloquent\Model;

class TransactionOrigin extends Model
{
    use TransactionOriginRelationship;

    /**
     * The database table used by the model.
     * @var string
     */
    protected $table = 'journal_entry_origin';

    /**
     * Mass Assignable fields of model
     * @var array
     */
    protected $fillable = [];

    /**
     * Default values for model fields
     * @var array
     */
    protected $attributes = [];

    /**
     * Guarded fields of model
     * @var array
     */
    protected $guarded = ['id'];
    
    /**
     * Timestamps
     */
    public $timestamps = false;

    /**
     * model life cycle event listeners
     * @return void
     */
    protected static function boot()
    {
        parent::boot();

        static::addGlobalScope('ins', function ($builder) {
            $builder->where('ins', auth()->user()->ins);
        });
    }
}
