<?php

namespace App\Models\utility_bill\Traits;


trait UtilityBillAttribute
{
    // Make your attributes functions here
    // Further, see the documentation : https://laravel.com/docs/5.4/eloquent-mutators#defining-an-accessor


    /**
     * Action Button Attribute to show in grid
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return $this->getViewButtonAttribute("manage-bill", "biller.utility-bills.show") . ' ' 
            . $this->getEditButtonAttribute("edit-bill", "biller.utility-bills.edit") . ' ' 
            . $this->getDeleteButtonAttribute("delete-bill", "biller.utility-bills.destroy");
    }

    /**
     * Transaction ID code
     * 
     * @return float
     */
    public function getTidCodeAttribute()
    {
        return gen4tid('BILL-', $this->tid);
    }

    /**
     * Invoice amount received
     * 
     * @return float
     */
    public function getAmountReceivedAttribute()
    {
        return +$this->payments()->sum('amount');
    }

    /**
     * Bill Status
     * 
     * @return float
     */
    public function getStatusAttribute()
    {
        $status = 'due';
        $amount_due = round($this->total);
        $amount_received = round($this->getAmountReceivedAttribute());
        if ($amount_received > 0 && $amount_received < $amount_due) $status = 'partial';
        if ($amount_received >= $amount_due) $status = 'paid';
        
        return $status;
    }

    /**
     * Allocated Opening balance
     */
    public function getIsAllocatedOpeningBalanceAttribute()
    {
        return $this->payments()->whereNotNull('payment_id')->exists();
    }
}
