<?php

namespace App\Models\utility_bill;

use App\Models\ModelTrait;
use App\Models\utility_bill\Traits\UtilityBillAttribute;
use App\Models\utility_bill\Traits\UtilityBillRelationship;
use Illuminate\Database\Eloquent\Model;


class UtilityBill extends Model
{
    use ModelTrait, UtilityBillAttribute, UtilityBillRelationship;

    /**
     * NOTE : If you want to implement Soft Deletes in this model,
     * then follow the steps here : https://laravel.com/docs/5.4/eloquent#soft-deleting
     */

    /**
     * The database table used by the model.
     * 
     * @var string
     */
    protected $table = 'invoices';

    /**
     * Mass Assignable fields of model
     * 
     * @var array
     */
    protected $fillable = [];

    /**
     * Default values for model fields
     * 
     * @var array
     */
    protected $attributes = [];

    /**
     * Dates
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    /**
     * Guarded fields of model
     * 
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Constructor of Model
     * 
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    /**
     * model life cycle event listeners
     * 
     * @return void
     */
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($invoice) {
            $invoice->fill([
                'user_id' => auth()->user()->id,
                'ins' => auth()->user()->ins,
            ]);
            return $invoice;
        });

        static::addGlobalScope('ins', function ($builder) {
            $builder->whereNotNull('supplier_id')->where('ins', auth()->user()->ins);
        });
    }
}
