<?php

namespace App\Models\warehouse_row;

use App\Models\ModelTrait;

use Illuminate\Database\Eloquent\Model;
use App\Models\warehouse_row\Traits\WarehouseRowRelationship;
use App\Models\Warehouse_row\Traits\WarehouseRowAttribute;

class WareHouseRow extends Model
{
    use ModelTrait, WarehouseRowAttribute, WarehouseRowRelationship;
    protected $table = 'ware_house_rows';

    protected $fillable = [
        'ware_house_id','row_number', 'extra', 'ins'
    ];

    protected $attributes = [

    ];
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    protected $guarded = [
        'id'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
            parent::boot();
            static::addGlobalScope('ins', function($builder){
            $builder->where('ins', '=', auth()->user()->ins);
    });
    }
}
