<?php

namespace App\Models\warehouse_shelves;

use App\Models\ModelTrait;
use Illuminate\Database\Eloquent\Model;
use App\Models\warehouse_shelves\Traits\WarehouseShelfAttribute;
use App\Models\warehouse_shelves\Traits\WarehouseShelfRelationship;

class WarehouseShelf extends Model
{

    use ModelTrait, WarehouseShelfAttribute,WarehouseShelfRelationship;

    protected $table = 'warehouse_shelves';

    protected $fillable = [
        'warehouse_id','warehouse_row_id','row_number','shelf_number', 'extra', 'ins', 'length', 'width', 'height'
    ];

    protected $attributes = [

    ];
    protected $dates = [
        'created_at',
        'updated_at'
    ];

    protected $guarded = [
        'id'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }
    protected static function boot()
    {
            parent::boot();
            static::addGlobalScope('ins', function($builder){
            $builder->where('ins', '=', auth()->user()->ins);
    });
    }
}
