<?php

namespace App\Models\waste_management\Traits;

use App\Models\assembly\assembly_station\AssemblyStation;
use App\Models\product\Product;
use App\Models\productvariable\Productvariable;
use App\Models\waste_management\WasteManagement;
use App\Models\Access\User\User;

trait WasteManagementItemsRelationship
{
    public function waste_management(){
        return $this->belongsTo(WasteManagement::class);
    }

    public function station()
    {
        return $this->belongsTo(AssemblyStation::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function unit(){
        return $this->belongsTo(Productvariable::class, 'uom');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
