<?php

namespace App\Models\work_order\Traits;

use App\Models\work_order\WorkOrder;

trait WorkOrderAttribute
{
    /**
     * Action Button Attribute to show in grid
     * 
     * @return string
     */
    public function getActionButtonsAttribute()
    {
        return '
            '.$this->getViewButtonAttribute("manage-product", "biller.work_orders.show").'
                '.$this->getEditButtonAttribute("edit-product", "biller.work_orders.edit").'
                '.$this->getDeleteButtonAttribute("delete-product", "biller.work_orders.destroy").'
                ';
    }

    /**
     * Transaction ID code
     * 
     * @return float
     */
    public function getTidCodeAttribute()
    {
        return gen4tid('WO-', $this->tid);
    }

    /**
     * Next Transaction ID code
     * 
     * @return float
     */
    public function getNextTidCodeAttribute()
    {
        $tid = WorkOrder::max('tid')+1;
        return gen4tid('WO-', $tid);
    }
}
