<?php

namespace App\Repositories\Focus;

use App\Models\account\Account;
use App\Models\invoice\Invoice;
use App\Models\items\InvoicePaymentItem;
use App\Models\items\JournalItem;
use App\Models\manualjournal\Journal;
use App\Models\transaction\Transaction;
use App\Models\transaction\TransactionOrigin;

trait JournalEntryService
{
    /**
     * Customer and Supplier Opening Balance
     */
    public function opening_balance_acc($instance, $method)
    {
        switch ($method) {
            case 'store':
                $suspense_account = Account::where('system', 'share_capital')->first(['id']);
                if ($instance['inp_invoices']) {
                    foreach ($instance['inp_invoices'] as $inv_data) {
                        // raise invoice
                        $frx_rate = $instance->frx_rate;
                        $invoice = Invoice::create([
                            'customer_id' => $instance->customer_id,
                            'supplier_id' => $instance->supplier_id,
                            'tid' => $inv_data['inv_no'],
                            'date' => $inv_data['inv_date'],
                            'due_date' => $inv_data['inv_due_date'],
                            'note' => $inv_data['inv_descr'],
                            'subtotal' => $inv_data['inv_amount'],
                            'total' => $inv_data['inv_amount'],
                            'frx_subtotal' => $frx_rate > 1? round($inv_data['inv_amount'] * $frx_rate, 4) : 0,
                            'frx_total' => $frx_rate > 1? round($inv_data['inv_amount'] * $frx_rate, 4) : 0,
                            'currency_id' => $instance->currency_id,
                            'frx_rate' => $frx_rate,
                        ]);
                        if ($inv_data['inv_amountpaid'] > 0) {
                            InvoicePaymentItem::create([
                                'invoice_id' => $invoice->id,
                                'name' => $invoice->note,
                                'rate' => $inv_data['inv_amountpaid'],
                                'amount' => $inv_data['inv_amountpaid'],
                                'frx_rate' => $frx_rate > 1? round($frx_rate * $inv_data['inv_amountpaid'], 4) : 0,
                                'frx_amount' => $frx_rate > 1? round($frx_rate * $inv_data['inv_amountpaid'], 4) : 0,
                            ]);
                        }

                        // manual journal entry
                        $mnl_journal = Journal::create([
                            'customer_id' => $instance->customer_id,
                            'supplier_id' => $instance->supplier_id,
                            'invoice_id' => $invoice->id,
                            'date' => $inv_data['inv_date'],
                            'note' => $inv_data['inv_descr'],
                            'debit_ttl' => $inv_data['inv_amount'],
                            'credit_ttl' => $inv_data['inv_amount'],
                        ]);

                        if ($instance->customer_id) {
                            foreach(range(0,1) as $n) {
                                if ($n < 1) {
                                    JournalItem::create([
                                        'parent_id' => $mnl_journal->id,
                                        'ledger_id' => $instance->ledger_id,
                                        'debit' => $inv_data['inv_amount'],
                                    ]);
                                } else {
                                    JournalItem::create([
                                        'parent_id' => $mnl_journal->id,
                                        'ledger_id' => $suspense_account->id,
                                        'credit' => $inv_data['inv_amount'],
                                    ]);
                                }
                            }
                            // debit Accounts Receivable (Debtor)
                            $dr_data = [
                                'tid' => Transaction::max('tid')+1,
                                'ledger_id' => $instance->ledger_id,
                                'debit' => $frx_rate > 1? round($inv_data['inv_amount'] * $frx_rate, 4) : $inv_data['inv_amount'],
                                'frx_debit' => $frx_rate > 1? $inv_data['inv_amount'] : 0,
                                'frx_rate' => $frx_rate,
                                'date' => $inv_data['inv_date'],
                                'note' => $inv_data['inv_descr'],
                                'customer_id' => $instance->customer_id,
                                'supplier_id' => $instance->supplier_id,
                            ];
                            $dr_entry = Transaction::create($dr_data);
                            // credit Suspense Account (Equity)
                            unset($dr_data['debit'], $dr_data['frx_debit']);
                            $cr_data = array_replace($dr_data, [
                                'ledger_id' => $suspense_account->id, 
                                'credit' => $frx_rate > 1? round($inv_data['inv_amount'] * $frx_rate, 4) : $inv_data['inv_amount'],
                                'frx_credit' => $frx_rate > 1? $inv_data['inv_amount'] : 0,
                            ]);
                            $cr_entry = Transaction::create($cr_data);
                            TransactionOrigin::insert([
                                ['journal_entry_id' => $dr_entry->id, 'mnl_journal_id' => $mnl_journal->id, 'ins' => $mnl_journal->ins],
                                ['journal_entry_id' => $cr_entry->id, 'mnl_journal_id' => $mnl_journal->id, 'ins' => $mnl_journal->ins]
                            ]);
                        } elseif ($instance->supplier_id) {
                            foreach(range(0,1) as $n) {
                                if ($n < 1) {
                                    JournalItem::create([
                                        'parent_id' => $mnl_journal->id,
                                        'ledger_id' => $suspense_account->id,
                                        'debit' => $inv_data['inv_amount'],
                                    ]);
                                } else {
                                    JournalItem::create([
                                        'parent_id' => $mnl_journal->id,
                                        'ledger_id' => $instance->ledger_id,
                                        'credit' => $inv_data['inv_amount'],
                                    ]);
                                }
                            }
                            // debit Suspense Account (Equity)
                            $dr_data = [
                                'tid' => Transaction::max('tid')+1,
                                'ledger_id' => $suspense_account->id, 
                                'debit' => $frx_rate > 1? round($inv_data['inv_amount'] * $frx_rate, 4) : $inv_data['inv_amount'],
                                'frx_debit' => $frx_rate > 1? $inv_data['inv_amount'] : 0,
                                'frx_rate' => $frx_rate,
                                'date' => $inv_data['inv_date'],
                                'note' => $inv_data['inv_descr'],
                                'customer_id' => $instance->customer_id,
                                'supplier_id' => $instance->supplier_id,
                            ];
                            $dr_entry = Transaction::create($dr_data);
                            // credit Accounts Payable (Creditor)
                            unset($dr_data['debit'], $dr_data['frx_debit']);
                            $cr_data = array_replace($dr_data, [
                                'ledger_id' => $instance->ledger_id,
                                'credit' => $frx_rate > 1? round($inv_data['inv_amount'] * $frx_rate, 4) : $inv_data['inv_amount'],
                                'frx_credit' => $frx_rate > 1? $inv_data['inv_amount'] : 0,
                            ]);
                            $cr_entry = Transaction::create($cr_data);
                            TransactionOrigin::insert([
                                ['journal_entry_id' => $dr_entry->id, 'mnl_journal_id' => $mnl_journal->id, 'ins' => $mnl_journal->ins],
                                ['journal_entry_id' => $cr_entry->id, 'mnl_journal_id' => $mnl_journal->id, 'ins' => $mnl_journal->ins]
                            ]);
                        }
                        
                    }
                } else {
                    // raise invoice
                    $frx_rate = $instance->frx_rate;
                    $invoice = Invoice::create([
                        'customer_id' => $instance->customer_id,
                        'supplier_id' => $instance->supplier_id,
                        'tid' => '0',
                        'date' => $instance->open_balance_date,
                        'due_date' => $instance->open_balance_date,
                        'note' => $instance->open_balance_note,
                        'subtotal' => $instance->open_balance,
                        'total' => $instance->open_balance,
                        'frx_subtotal' => $frx_rate > 1? round($instance->open_balance * $frx_rate, 4) : 0,
                        'frx_total' => $frx_rate > 1? round($instance->open_balance * $frx_rate, 4) : 0,
                        'currency_id' => $instance->currency_id,
                        'frx_rate' => $frx_rate,
                    ]);

                    // manual journal entry
                    $mnl_journal = Journal::create([
                        'customer_id' => $instance->customer_id,
                        'supplier_id' => $instance->supplier_id,
                        'invoice_id' => $invoice->id,
                        'date' => $instance->open_balance_date,
                        'note' => $instance->open_balance_note,
                        'debit_ttl' => $instance->open_balance,
                        'credit_ttl' => $instance->open_balance,
                    ]);

                    if ($instance['customer_id']) {
                        foreach(range(0,1) as $n) {
                            if ($n < 1) {
                                JournalItem::create([
                                    'parent_id' => $mnl_journal->id,
                                    'ledger_id' => $instance->ledger_id,
                                    'debit' => $instance->open_balance,
                                ]);
                            } else {
                                JournalItem::create([
                                    'parent_id' => $mnl_journal->id,
                                    'ledger_id' => $suspense_account->id,
                                    'credit' => $instance->open_balance,
                                ]);
                            }
                        }
                        // debit Accounts Receivable (Debtor)
                        $dr_data = [
                            'tid' => Transaction::max('tid')+1,
                            'ledger_id' => $instance->ledger_id,
                            'debit' => $frx_rate > 1? round($instance->open_balance * $frx_rate, 4) : $instance->open_balance,
                            'frx_debit' => $frx_rate > 1? $instance->open_balance : 0,
                            'frx_rate' => $frx_rate,
                            'date' => $instance->open_balance_date,
                            'note' => $instance->open_balance_note,
                            'customer_id' => $instance->customer_id,
                            'supplier_id' => $instance->supplier_id,
                        ];
                        $dr_entry = Transaction::create($dr_data);
                        // credit Suspense Account (Equity)
                        unset($dr_data['debit'], $dr_data['frx_debit']);
                        $cr_data = array_replace($dr_data, [
                            'ledger_id' => $suspense_account->id, 
                            'credit' => $frx_rate > 1? round($instance->open_balance * $frx_rate, 4) : $instance->open_balance,
                            'frx_credit' => $frx_rate > 1? $instance->open_balance : 0,
                        ]);
                        $cr_entry = Transaction::create($cr_data);
                    } elseif ($instance['supplier_id']) {
                        foreach(range(0,1) as $n) {
                            if ($n < 1) {
                                JournalItem::create([
                                    'parent_id' => $mnl_journal->id,
                                    'ledger_id' => $suspense_account->id,
                                    'debit' => $instance->open_balance,
                                ]);
                            } else {
                                JournalItem::create([
                                    'parent_id' => $mnl_journal->id,
                                    'ledger_id' => $instance->ledger_id,
                                    'credit' => $instance->open_balance,
                                ]);
                            }
                        }
                        // debit Suspense Account (Equity) 
                        $dr_data = [
                            'tid' => Transaction::max('tid')+1,
                            'ledger_id' => $suspense_account->id, 
                            'debit' => $frx_rate > 1? round($instance->open_balance * $frx_rate, 4) : $instance->open_balance,
                            'frx_debit' => $frx_rate > 1? $instance->open_balance : 0,
                            'frx_rate' => $frx_rate,
                            'date' => $instance->open_balance_date,
                            'note' => $instance->open_balance_note,
                            'customer_id' => $instance->customer_id,
                            'supplier_id' => $instance->supplier_id,
                        ];
                        $dr_entry = Transaction::create($dr_data);
                        // credit Accounts Payable (Creditor)
                        unset($dr_data['debit']);
                        $cr_data = array_replace($dr_data, [
                            'ledger_id' => $instance->ledger_id,
                            'credit' => $instance->open_balance,
                        ]);
                        $cr_entry = Transaction::create($cr_data);
                    }
                    
                    TransactionOrigin::insert([
                        ['journal_entry_id' => $dr_entry->id, 'mnl_journal_id' => $mnl_journal->id, 'ins' => $mnl_journal->ins],
                        ['journal_entry_id' => $cr_entry->id, 'mnl_journal_id' => $mnl_journal->id, 'ins' => $mnl_journal->ins]
                    ]);
                }
                break;

            case 'update':
                $prev_invoices = $instance->opening_balance_invoices()->get();
                if (!$prev_invoices->count()) {
                    $this->opening_balance_acc($instance, $method='store');
                } else {
                    // lump sum balance update
                    $invoice = $prev_invoices[0];
                    if ($invoice->tid === '0' && !$invoice->payments()->exists()) {
                        $this->opening_balance_acc($instance, $method='delete');
                        $this->opening_balance_acc($instance, $method='store');
                    } else {
                        // dynamic invoices update
                        $invoice_ids = array_map(fn($v) => @$v['invoice_id'], $instance['inp_invoices']);
                        $paid_invoices = $instance->opening_balance_invoices()
                            ->whereIn('id', $invoice_ids)
                            ->where(fn($q) => $q->whereHas('payments'))
                            ->pluck('id')->toArray();

                        // ammend paid invoices
                        foreach ($instance['inp_invoices'] as $data) {
                            $invoice = Invoice::find($data['invoice_id']);
                            if ($invoice) {
                                $invoice->update([
                                    'tid' => $data['inv_no'],
                                    'date' => $data['inv_date'],
                                    'due_date' => $data['inv_due_date'],
                                    'note' => $data['inv_descr'],
                                ]);
                                $manual_journal = $invoice->manual_journal;
                                if ($manual_journal) {
                                    $manual_journal->update([
                                        'date' => $invoice->date,
                                        'note' => $invoice->note,
                                    ]);
                                    foreach ($manual_journal->transactions as $tr) {
                                        $tr->update(['date' => $manual_journal->date, 'note' => $manual_journal->note]);
                                    }
                                }
                            }
                        }
                        
                        // remove old invoices
                        $unpaid_invoices = $instance->opening_balance_invoices()->whereNotIn('id', $paid_invoices)->pluck('id')->toArray();
                        $mnl_journals = $instance->manual_journals()->whereIn('invoice_id', $unpaid_invoices)->get();
                        foreach ($mnl_journals as $row) {
                            $row->transactions()->delete();
                            $row->transaction_origins()->delete();
                            $row->delete();
                        }
                        InvoicePaymentItem::whereIn('invoice_id', $unpaid_invoices)->delete();
                        Invoice::whereIn('id', $unpaid_invoices)->delete(); 
                        
                        // raise new invoices
                        $new_invoices = array_filter($instance['inp_invoices'], fn($v) => !in_array($v['invoice_id'], $paid_invoices));                        
                        if ($new_invoices) {
                            $instance['inp_invoices'] = $new_invoices;
                            $this->opening_balance_acc($instance, $method='store');
                        }
                    }
                }
                break;
                
            case 'delete':
                $invoice_ids = $instance->opening_balance_invoices()->pluck('id')->toArray();
                $mnl_journals = $instance->manual_journals()->whereIn('invoice_id', $invoice_ids)->get();
                foreach ($mnl_journals as $row) {
                    $row->transactions()->delete();
                    $row->transaction_origins()->delete();
                    $row->delete();
                }
                InvoicePaymentItem::whereIn('invoice_id', $invoice_ids)->delete();
                $instance->opening_balance_invoices()->delete();
                break;
        }
        return true;
    }

    /**
     * Account Money Transfer
     */
    public function money_transfer_acc($instance, $method)
    {
        switch ($method) {
            case 'store':
                // debit Destination Account
                $account = Account::where('system', 'bank_charge')->first(['id']);
                $dr_data = [
                    'tid' => Transaction::max('tid')+1,
                    'ledger_id' => $account->id, 
                    'debit' => $instance->amount,
                    'date' => $instance->date,
                    'note' => $instance->note,
                ];
                $debit_tr = Transaction::create($dr_data);
                // credit Source Account
                unset($dr_data['debit']);
                $credit_tr = Transaction::create(array_replace($dr_data, [
                    'ledger_id' => $instance->ledger_id, 
                    'credit' => $instance->amount,
                ]));

                if ($instance['bank_transfer_id']) {
                    TransactionOrigin::insert([
                        ['journal_entry_id' => $debit_tr->id, 'bank_transfer_id' => $instance->id, 'ins' => $instance->ins],
                        ['journal_entry_id' => $credit_tr->id, 'bank_transfer_id' => $instance->id, 'ins' => $instance->ins],
                    ]);
                } elseif ($instance['charge_id']) {
                    TransactionOrigin::insert([
                        ['journal_entry_id' => $debit_tr->id, 'charge_id' => $instance->id, 'ins' => $instance->ins],
                        ['journal_entry_id' => $credit_tr->id, 'charge_id' => $instance->id, 'ins' => $instance->ins],
                    ]);
                }
                break;

            case 'update':
                $this->money_transfer_acc($instance, 'delete');
                $this->money_transfer_acc($instance, 'store');
                break;

            case 'delete':
                $instance->transactions()->delete();
                $instance->transaction_origins()->delete();
                break;
        }
        return true;
    }

    /**
     * Sales and Purchase Returns
     */
    public function sales_return_acc($instance, $method)
    {
        switch ($method) {
            case 'store':
                $tid = Transaction::max('tid')+1;
                $invoice = $instance->invoice;
                $frx_rate = $instance->frx_rate;
                if ($instance->customer_id) {
                    if (@$invoice->account_id) {
                        // debit Income Account
                        if ($instance->frx_taxable || $instance->taxable) {
                            $dr_data = [
                                'tid' => $tid,
                                'customer_id' => $instance->customer_id, 
                                'ledger_id' => $invoice->account_id, 
                                'debit' => $frx_rate > 1 ? $instance->frx_taxable : $instance->taxable,
                                'frx_debit' => $frx_rate > 1 ? $instance->taxable : 0,
                                'frx_rate' => $frx_rate,
                                'currency_id' => $invoice->currency_id,
                                'date' => $instance->date,
                                'note' => $instance->note,
                            ];
                            $income_dr = Transaction::create($dr_data);
                            TransactionOrigin::insert([
                                ['journal_entry_id' => $income_dr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins],
                            ]);
                        }
        
                        // debit Tax Account
                        if ($instance->tax > 0) {
                            $account = Account::where('system', 'tax')->first(['id']);
                            $tax_dr = Transaction::create(array_replace($dr_data, [
                                'ledger_id' => $account->id, 
                                'debit' => $frx_rate > 1 ? $instance->frx_tax : $instance->tax,
                                'frx_debit' => $frx_rate > 1 ? $instance->tax : 0,
                            ]));
                            TransactionOrigin::insert([
                                ['journal_entry_id' => $tax_dr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins],
                            ]);
                        }
        
                        // credit Accounts Receivable (Debtor)
                        unset($dr_data['debit'],$dr_data['frx_debit']);
                        $receivables_cr = Transaction::create(array_replace($dr_data, [
                            'ledger_id' => $instance->customer->ledger_id, 
                            'credit' => $frx_rate > 1 ? $instance->frx_total : $instance->total,
                            'frx_credit' => $frx_rate > 1 ? $instance->total : 0,
                        ]));
                        TransactionOrigin::create(['journal_entry_id' => $receivables_cr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins],);
                    }
                    // return goods
                    foreach ($instance->items as $item) {
                        // debit Inventory
                        $dr_data = [
                            'tid' => $tid,
                            'customer_id' => $instance->customer_id, 
                            'date' => $instance->date,
                            'note' => $instance->note,
                        ];
                        $stock_dr = Transaction::create(array_replace($dr_data, [
                            'ledger_id' => $item->ledger_id, 
                            'debit' => $item->amount,
                        ]));
                        // credit Sales Return Account
                        $account = Account::where('system', 'sale_return')->first(['id']);
                        $sale_return_cr = Transaction::create(array_replace($dr_data, [
                            'ledger_id' => $account->id, 
                            'credit' => $item->amount,
                        ]));
                        TransactionOrigin::insert([
                            ['journal_entry_id' => $stock_dr->id, 'payment_id' => $instance->id, 'product_id' => $item->product_id, 'ins' => $instance->ins],
                            ['journal_entry_id' => $sale_return_cr->id, 'payment_id' => $instance->id, 'product_id' => $item->product_id, 'ins' => $instance->ins],
                        ]);
                    }                
                } elseif ($instance->supplier_id) {
                    // debit Accounts Payable (Creditor)
                    $dr_data = [
                        'tid' => $tid,
                        'supplier_id' => $instance->supplier_id, 
                        'ledger_id' => @$instance->supplier->ledger_id, 
                        'debit' => $frx_rate > 1 ? $instance->frx_total : $instance->total,
                        'frx_debit' => $frx_rate > 1 ? $instance->total : 0,
                        'frx_rate' => $frx_rate,
                        'currency_id' => $invoice->currency_id,
                        'date' => $instance->date,
                        'note' => $instance->note,
                    ];
                    $payable_dr = Transaction::create($dr_data);
                    TransactionOrigin::create(['journal_entry_id' => $payable_dr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins],);
    
                    // credit Tax Account
                    if ($instance->tax > 0) {
                        $account = Account::where('system', 'tax')->first(['id']);
                        $tax_dr = Transaction::create(array_replace($dr_data, [
                            'ledger_id' => $account->id, 
                            'debit' => $frx_rate > 1 ? $instance->frx_tax : $instance->tax,
                            'frx_debit' => $frx_rate > 1 ? $instance->tax : 0,
                        ]));
                        TransactionOrigin::create(['journal_entry_id' => $tax_dr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins]);
                    }
    
                    // credit Purchases Return
                    if ($instance->frx_taxable || $instance->taxable) {
                        unset($dr_data['debit'],$dr_data['frx_debit']);
                        $account = Account::where('system', 'purchase_return')->first(['id']);
                        $receivables_cr = Transaction::create(array_replace($dr_data, [
                            'ledger_id' => $account->id, 
                            'credit' => $frx_rate > 1 ? $instance->frx_taxable : $instance->taxable,
                            'frx_credit' => $frx_rate > 1 ? $instance->taxable : 0,
                        ]));
                        TransactionOrigin::create(['journal_entry_id' => $receivables_cr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins],);
                    }                    
                }
                break;

            case 'update':
                $this->sales_return_acc($instance, 'delete');
                $this->sales_return_acc($instance, 'store');
                break;

            case 'delete':
                $instance->transactions()->delete();
                $instance->transaction_origins()->delete();
                break;
        }
        return true;
    }

    /**
     * Receive Invoice Deposit / Make Bill Payment 
     */
    public function invoice_payment_acc($instance, $method)
    {
        switch ($method) {
            case 'store':
                $tid = Transaction::max('tid')+1;
                $frx_rate = $instance->frx_rate;
                $tr_data = [
                    'tid' => $tid,
                    'customer_id' => $instance->customer_deposit? $instance->customer_id : null, 
                    'supplier_id' => $instance->supplier_payment? $instance->supplier_id : null,
                    'frx_rate' => $frx_rate,
                    'currency_id' => $instance->currency_id,
                    'date' => $instance->date,
                    'note' => $instance->note,
                ];
                if ($instance->customer_deposit) {
                    /* receive pre-payment */
                    if ($instance->pre_payment) {
                        // debit Bank (cash account)
                        $dr_data = array_replace($tr_data, [
                            'ledger_id' => $instance->ledger_id, 
                            'debit' => $frx_rate > 1 ? $instance->frx_amount : $instance->amount,
                            'frx_debit' => $frx_rate > 1 ? $instance->amount : 0,
                        ]);
                        $bank_dr = Transaction::create($dr_data);

                        // credit Customer Advances (Liability)
                        $account = Account::where('system', 'client_advance')->first(['id']);
                        $cr_data = array_replace($tr_data, [
                            'ledger_id' => $account->id,
                            'credit' => $frx_rate > 1? $instance->invoice_amount : $instance->amount,
                            'frx_credit' => $frx_rate > 1 ? $instance->amount : 0,
                        ]);
                        $client_advance_cr = Transaction::create($cr_data);
    
                        TransactionOrigin::insert([
                            ['journal_entry_id' => $bank_dr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins],
                            ['journal_entry_id' => $client_advance_cr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins],
                        ]);

                        // Gain/Loss on Foreign Exchange
                        if (isset($instance->frx_gain)) {
                            $account = Account::where('system', 'frx_gain_loss')->first(['id']);
                            // credit G/L on Foreign Exchange (Gain)
                            if ($instance->frx_gain > 0) {
                                $tr_data = array_replace($tr_data, [
                                    'ledger_id' => $account->id,
                                    'credit' => $instance->frx_gain,
                                    'frx_credit' => 0,
                                ]);
                            } elseif ($instance->frx_gain < 0) {
                                // debit G/L on Foreign Exchange (Loss)
                                $tr_data = array_replace($tr_data, [
                                    'ledger_id' => $account->id,
                                    'debit' => (-1 * $instance->frx_gain),
                                    'frx_debit' => 0,
                                ]);
                            }
                            $frx_cr = Transaction::create($tr_data);
                            TransactionOrigin::create(['journal_entry_id' => $frx_cr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins]);
                        }
                    } else {
                        /* standard invoice payment */
                        // debit bank (cash account)
                        $dr_data = array_replace($tr_data, [
                            'ledger_id' => $instance->ledger_id, 
                            'debit' => $frx_rate > 1 ? $instance->frx_amount : $instance->amount,
                            'frx_debit' => $frx_rate > 1 ? $instance->amount : 0,
                        ]);
                        $bank_dr = Transaction::create($dr_data);
    
                        // Credit Accounts Receivables (Debtors)
                        $cr_data = array_replace($tr_data, [
                            'ledger_id' => @$instance->customer->ledger_id,
                            'credit' => $frx_rate > 1? $instance->invoice_amount : $instance->amount,
                            'frx_credit' => $frx_rate > 1 ? $instance->amount : 0,
                        ]);
                        $receivable_cr = Transaction::create($cr_data);
    
                        TransactionOrigin::insert([
                            ['journal_entry_id' => $bank_dr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins],
                            ['journal_entry_id' => $receivable_cr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins],
                        ]);
                        
                        // Gain/Loss on Foreign Exchange
                        if (isset($instance->frx_gain)) {
                            $account = Account::where('system', 'frx_gain_loss')->first(['id']);
                            // credit (Gain)
                            if ($instance->frx_gain > 0) {
                                $tr_data = array_replace($tr_data, [
                                    'ledger_id' => $account->id,
                                    'credit' => $instance->frx_gain,
                                    'frx_credit' => 0,
                                ]);
                            } elseif ($instance->frx_gain < 0) {
                                // debit (Loss)
                                $tr_data = array_replace($tr_data, [
                                    'ledger_id' => $account->id,
                                    'debit' => (-1 * $instance->frx_gain),
                                    'frx_debit' => 0,
                                ]);
                            }
                            $frx_cr = Transaction::create($tr_data);
                            TransactionOrigin::create(['journal_entry_id' => $frx_cr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins]);
                        }

                    }
                } else {
                    /* receive pre-payment */
                    if ($instance->pre_payment) {
                        // credit Bank (cash account)
                        $dr_data = array_replace($tr_data, [
                            'ledger_id' => $instance->ledger_id, 
                            'credit' => $frx_rate > 1 ? $instance->frx_amount : $instance->amount,
                            'frx_credit' => $frx_rate > 1 ? $instance->amount : 0,
                        ]);
                        $bank_cr = Transaction::create($dr_data);

                        // debit Supplier Advances (Asset)
                        $account = Account::where('system', 'supplier_advance')->first(['id']);
                        $dr_data = array_replace($tr_data, [
                            'ledger_id' => $account->id,
                            'debit' => $frx_rate > 1? $instance->invoice_amount : $instance->amount,
                            'frx_debit' => $frx_rate > 1 ? $instance->amount : 0,
                        ]);
                        $supplier_advance_dr = Transaction::create($dr_data);
    
                        TransactionOrigin::insert([
                            ['journal_entry_id' => $bank_cr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins],
                            ['journal_entry_id' => $supplier_advance_dr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins],
                        ]);

                        // Gain/Loss on Foreign Exchange
                        if (isset($instance->frx_gain)) {
                            $account = Account::where('system', 'frx_gain_loss')->first(['id']);
                            // debit G/L on Foreign Exchange (Gain)
                            if ($instance->frx_gain > 0) {
                                $tr_data = array_replace($tr_data, [
                                    'ledger_id' => $account->id,
                                    'debit' => $instance->frx_gain,
                                    'frx_debit' => 0,
                                ]);
                            } elseif ($instance->frx_gain < 0) {
                                // credit G/L on Foreign Exchange (Loss)
                                $tr_data = array_replace($tr_data, [
                                    'ledger_id' => $account->id,
                                    'credit' => (-1 * $instance->frx_gain),
                                    'frx_credit' => 0,
                                ]);
                            }
                            $frx_cr = Transaction::create($tr_data);
                            TransactionOrigin::create(['journal_entry_id' => $frx_cr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins]);
                        }
                    } else {
                        /* standard invoice payment */

                        // credit bank (cash account)
                        $dr_data = array_replace($tr_data, [
                            'ledger_id' => $instance->ledger_id, 
                            'credit' => $frx_rate > 1 ? $instance->frx_amount : $instance->amount,
                            'frx_credit' => $frx_rate > 1 ? $instance->amount : 0,
                        ]);
                        $bank_cr = Transaction::create($dr_data);
    
                        // debit Accounts Payable (Creditor)
                        $account = Account::where('system', 'payable')->first(['id']);
                        $cr_data = array_replace($tr_data, [
                            'ledger_id' => $account->id,
                            'debit' => $frx_rate > 1? $instance->invoice_amount : $instance->amount,
                            'frx_debit' => $frx_rate > 1 ? $instance->amount : 0,
                        ]);
                        $payable_dr = Transaction::create($cr_data);
    
                        TransactionOrigin::insert([
                            ['journal_entry_id' => $bank_cr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins],
                            ['journal_entry_id' => $payable_dr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins],
                        ]);
                        
                        // Gain/Loss on Foreign Exchange
                        if (isset($instance->frx_gain)) {
                            $account = Account::where('system', 'frx_gain_loss')->first(['id']);
                            // credit (Gain)
                            if ($instance->frx_gain > 0) {
                                $tr_data = array_replace($tr_data, [
                                    'ledger_id' => $account->id,
                                    'credit' => $instance->frx_gain,
                                    'frx_credit' => 0,
                                ]);
                            } elseif ($instance->frx_gain < 0) {
                                // debit (Loss)
                                $tr_data = array_replace($tr_data, [
                                    'ledger_id' => $account->id,
                                    'debit' => (-1 * $instance->frx_gain),
                                    'frx_debit' => 0,
                                ]);
                            }
                            $frx_cr = Transaction::create($tr_data);
                            TransactionOrigin::create(['journal_entry_id' => $frx_cr->id, 'payment_id' => $instance->id, 'ins' => $instance->ins]);
                        }

                    }
                }
                break;

            case 'update':
                $this->invoice_payment_acc($instance, 'delete');
                $this->invoice_payment_acc($instance, 'store');
                break;

            case 'delete':
                $instance->transactions()->delete();
                $instance->transaction_origins()->delete();
                break;
        }
        return true;
    }

    /**
     * Generate Invoice or Expend Item
     */
    public function generate_invoice_acc($instance, $method)
    {
        switch ($method) {
            case 'store':
                if ($instance->customer_id) {
                    // debit Accounts Receivable (Debtor)
                    $frx_rate = $instance->frx_rate;
                    $dr_data = [
                        'tid' => Transaction::max('tid')+1,
                        'ledger_id' => $instance->customer->ledger_id,
                        'debit' => $frx_rate > 1? $instance->frx_total : $instance->total,
                        'frx_debit' => $frx_rate > 1? $instance->total : 0,
                        'frx_rate' => $frx_rate,
                        'date' => $instance->date,
                        'note' => $instance->note,
                        'customer_id' => $instance->customer_id,
                    ];
                    $dr_entry = Transaction::create($dr_data);
                    TransactionOrigin::insert([
                        ['journal_entry_id' => $dr_entry->id, 'invoice_id' => $instance->id, 'ins' => $instance->ins]
                    ]);
    
                    unset($dr_data['debit'], $dr_data['frx_debit']);
                    if ($instance->taxable > 0) {
                        // credit Revenue Account (Income)
                        $cr_data = array_replace($dr_data, [
                            'ledger_id' => $instance->ledger_id, 
                            'credit' => $frx_rate > 1? $instance->frx_taxable : $instance->taxable,
                            'frx_credit' => $frx_rate > 1? $instance->taxable : 0,
                        ]);
                        $revenue_cr = Transaction::create($cr_data);
    
                        // credit VAT (Tax)
                        $account = Account::where('system', 'tax')->first(['id']);
                        $cr_data = array_replace($dr_data, [
                            'ledger_id' => $account->id, 
                            'credit' => $frx_rate > 1? $instance->frx_tax : $instance->tax,
                            'frx_credit' => $frx_rate > 1? $instance->tax : 0,
                        ]);
                        $tax_cr = Transaction::create($cr_data);
                        TransactionOrigin::insert([
                            ['journal_entry_id' => $revenue_cr->id, 'invoice_id' => $instance->id, 'ins' => $instance->ins],
                            ['journal_entry_id' => $tax_cr->id, 'invoice_id' => $instance->id, 'ins' => $instance->ins],
                        ]);
                    } elseif ($instance->taxable == 0) {
                        // credit Revenue Account (Income)
                        $cr_data = array_replace($dr_data, [
                            'ledger_id' => $instance->ledger_id, 
                            'credit' => $frx_rate > 1? $instance->frx_total : $instance->total,
                            'frx_credit' => $frx_rate > 1? $instance->total : 0,
                        ]);
                        $revenue_cr = Transaction::create($cr_data);
                        TransactionOrigin::insert([
                            ['journal_entry_id' => $revenue_cr->id, 'invoice_id' => $instance->id, 'ins' => $instance->ins],
                        ]);
                    }
                } else {
                    // credit Accounts Payable (Creditor)
                    $frx_rate = $instance->frx_rate;
                    $cr_data = [
                        'tid' => Transaction::max('tid')+1,
                        'ledger_id' => $instance->customer->ledger_id,
                        'credit' => $frx_rate > 1? $instance->frx_total : $instance->total,
                        'frx_credit' => $frx_rate > 1? $instance->total : 0,
                        'frx_rate' => $frx_rate,
                        'date' => $instance->date,
                        'note' => $instance->note,
                        'customer_id' => $instance->customer_id,
                    ];
                    $cr_entry = Transaction::create($cr_data);
                    TransactionOrigin::insert([
                        ['journal_entry_id' => $cr_entry->id, 'invoice_id' => $instance->id, 'ins' => $instance->ins]
                    ]);
    
                    unset($cr_data['credit'], $dr_data['frx_credit']);
                    $account = Account::where('system', 'tax')->first(['id']);
                    foreach ($instance->items as $item) {
                        // debit Stock or Expense or Asset account
                        $dr_data = array_replace($cr_data, [
                            'ledger_id' => $item->ledger_id, 
                            'debit' => $frx_rate > 1? $item->frx_amount : $item->amount,
                            'frx_debit' => $frx_rate > 1? $item->amount : 0,
                        ]);
                        $dr_entry = Transaction::create($dr_data);
                        TransactionOrigin::insert([
                            ['journal_entry_id' => $dr_entry->id, 'invoice_id' => $instance->id, 'ins' => $instance->ins],
                        ]);

                        // debit VAT (Tax)
                        if ($item->tax > 0) {
                            $dr_data = array_replace($cr_data, [
                                'ledger_id' => $account->id, 
                                'debit' => $frx_rate > 1? $item->frx_tax : $item->tax,
                                'frx_debit' => $frx_rate > 1? $item->tax : 0,
                            ]);
                            $tax_dr = Transaction::create($dr_data);
                            TransactionOrigin::insert([
                                ['journal_entry_id' => $tax_dr->id, 'invoice_id' => $instance->id, 'ins' => $instance->ins],
                            ]);
                        }
                    }
                }

                break;

            case 'update':
                $this->money_transfer_acc($instance, 'delete');
                $this->money_transfer_acc($instance, 'store');
                break;

            case 'delete':
                $instance->transactions()->delete();
                $instance->transaction_origins()->delete();
                break;
        }
        return true;
    }
}
