<?php

namespace App\Repositories\Focus\assembly;

use App\Exceptions\GeneralException;
use App\Models\assembly\assembly_station_operator\AssemblyStationOperator;
use App\Repositories\BaseRepository;
use DB;
use Carbon\Carbon;

class AssemblyStationOperatorsRepository extends BaseRepository
{

    const MODEL = AssemblyStationOperator::class;

    public function getForDataTable()
    {
        $start_date = empty(request('dateId'))
        ? null
        : Carbon::parse(request('dateId'))
          ->startOfDay()
          ->toDateTimeString();

      $end_date = empty(request('dateId'))
        ? null
        : Carbon::parse(request('dateId'))
          ->endOfDay()
          ->toDateTimeString();

        $q = $this->query();

        $q->when(request('dateId'), function($q) use ($start_date, $end_date){
            $q->whereBetween('created_at', [$start_date, $end_date]);
        });
        $q->when(request('stationId'), function($q){
            $q->where('station', request('stationId'));
        });
        $q->when(request('operatorId'), function($q){
            $q->where('operator', request('operatorId'));
        });
        return $q->get();
    }

    public function create(array $input)
    {
        DB::beginTransaction();
        $result =  AssemblyStationOperator::create($input);
        DB::commit();
        if ($result) return $result;

        throw new GeneralException('Error assigning operator to a station.');
    }
    public function update($assembly_station, array $input)
    {
        // DB::beginTransaction();
        // if ($assembly_station->update($input)) {
        //     DB::commit();
        //     return true;
        // }

        // throw new GeneralException('Error Updating Assembly Station');
    }

    public function delete($assembly_station)
    {
        // DB::beginTransaction();
        // if($assembly_station->delete()){
        //     DB::commit();
        //     return true;
        // }

        // throw new GeneralException('Error deleting assembly station');
    }
}
