<?php

namespace App\Repositories\Focus\assembly;

use App\Exceptions\GeneralException;
use App\Models\assembly\material_issuing\MaterialIssuing;
use App\Models\assembly\material_issuing\MaterialIssuingItems;
use App\Repositories\BaseRepository;
use Illuminate\Support\Arr;
use DB;
use App\Models\product\ProductVariation;

class MaterialIssuingItemsRepository extends BaseRepository
{

    const MODEL = MaterialIssuingItems::class;

    public function getForDataTable()
    {
        $q = $this->query();

        $q->when(request('station'), function ($q) {
            $q->whereHas('material_issuing', function($q){
                $q->where('material_issuing.station', request('station'));
            });
        });

        $q->when(request('product'), function ($q) {
                $q->where('product_id', request('product'));
        });

        $q->when(request('warehouse'), function ($q) {
            $q->whereHas('material_issuing', function($q){
                $q->where('material_issuing.warehouse_id', request('warehouse'));
            });
        });

        $q->when(request('issue_date'), function ($q) {
            $q->whereHas('material_issuing', function($q){
                $q->where('material_issuing.issue_date', request('issue_date'));
            });
        });

        return $q->get();    }
}
