<?php

namespace App\Repositories\Focus\assembly;

use App\Exceptions\GeneralException;
use App\Models\assembly\material_issuing\MaterialIssuing;
use App\Models\assembly\material_issuing\MaterialIssuingItems;
use App\Repositories\BaseRepository;
use Illuminate\Support\Arr;
use DB;
use App\Models\product\ProductVariation;

class MaterialIssuingRepository extends BaseRepository
{

    const MODEL = MaterialIssuing::class;

    public function getForDataTable()
    {
        $q = $this->query();
        $q->when(request('station'), function ($q) {
            $q->where('station', request('station'));
        });
        $q->when(request('issue_date'), function ($q) {
            $q->where('issue_date',request('issue_date'));
        });

        return $q->get();
    }

    public function create(array $input)
    {
        // dd(auth()->user()->id);
        // dd($input);
        DB::beginTransaction();
        $material_issuing = MaterialIssuing::create([
            'tid' =>$input['tid'],
            'station' => $input['station'],
            'warehouse_id' => $input['warehouse_id'],
            'notes' => $input['notes'],
            'amount' => $input['amount'],
            'issue_date' => $input['issue_date'],
            'user_id' => $input['user_id'],
            'ins' => $input['ins'],
        ]);

        // dd($material_issuing);
        $data_items = Arr::only($input, ['product_id', 'current_stock_quantity', 'quantity_issued','uom','unit_cost','total_cost']);
        $data_items = modify_array($data_items);
        $data_items = array_filter($data_items, fn($v) => $v['quantity_issued'] > 0);

        foreach ($data_items as $i => $item) {
            // if($item['quantity_issued'] > $item['current_stock_quantity']){
            //     return;
            // }
            DB::table('product_variations')->where('parent_id',$item['product_id'])->decrement('qty', $item['quantity_issued']);
            $data_items[$i] = array_replace($item, [
                'material_issuing_id' =>$material_issuing->id,
                'ins' => $input['ins'],
                'user_id' => $input['user_id'],
                'issue_date' => $input['issue_date'],
                'created_at' => $material_issuing->created_at,
                'updated_at' => $material_issuing->updated_at,
            ]);
        }

        MaterialIssuingItems::insert($data_items);
        DB::commit();

        // dd($data_items);

        //Check quantity
        //Check alert Limit
        //Convert uom


        // return 1;
        if ($material_issuing) return $material_issuing;


        throw new GeneralException('Error issuing materials.');
    }
    public function update($material_issuing, array $input)
    {
        // dd($input);



        // foreach($material_issuing->material_issuing_items as $mi){
        //     dd($mi);
        // }

        DB::beginTransaction();
        $material_issuing->update([
            'tid' =>$input['tid'],
            'station' => $input['station'],
            'notes' => $input['notes'],
            'amount' => $input['amount'],
        ]);

        $data_items = Arr::only($input, ['product_id', 'current_stock_quantity', 'quantity_issued','uom','unit_cost','total_cost']);
        $data_items = modify_array($data_items);
        $data_items = array_filter($data_items, fn($v) => $v['quantity_issued'] > 0);



        foreach ($data_items as $i => $item) {
            $data_items[$i] = array_replace($item, [
                'material_issuing_id' =>$material_issuing->id,
                'ins' => $input['ins'],
                'created_at' => $material_issuing->created_at,
                'updated_at' => $material_issuing->updated_at,
            ]);
        }

        foreach($material_issuing->material_issuing_items as $mi){
            DB::table('product_variations')->where('parent_id',$mi->product_id)->increment('qty', $mi->quantity_issued);
        }

        // foreach ($data_items as $i => $item) {
        //     DB::table('product_variations')->where('parent_id',$item['product_id'])->increment('qty', $item['quantity_issued']);
        // }



        MaterialIssuingItems::where('material_issuing_id', $material_issuing->id)->delete();

        MaterialIssuingItems::insert($data_items);
        DB::commit();

        if ($material_issuing) return $material_issuing;

        throw new GeneralException('Error Updating Material Issuing');
    }

    public function delete($material_issuing)
    {
        DB::beginTransaction();

        // MaterialIssuingItems::where('material_issuing_id', $material_issuing->id)->delete();
        // MaterialIssuing::where('id', $material_issuing->id)->delete();
        if(MaterialIssuingItems::where('material_issuing_id', $material_issuing->id)->delete()){
            if(MaterialIssuing::where('id', $material_issuing->id)->delete()){
                DB::commit();
                return true;
            }
        }

        throw new GeneralException('Error deleting material issuing.');
    }
}
