<?php

namespace App\Repositories\Focus\banktransfer;

use App\Models\banktransfer\Banktransfer;
use App\Exceptions\GeneralException;
use App\Models\bank\Bank;
use App\Repositories\BaseRepository;
use App\Repositories\Focus\JournalEntryService;
use Illuminate\Support\Facades\DB;

/**
 * Class BankRepository.
 */
class BanktransferRepository extends BaseRepository
{
    use JournalEntryService;

    /**
     * Associated Repository Model.
     */
    const MODEL = Banktransfer::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {
        return $this->query()->get();
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        // dd($input);
        foreach ($input as $key => $value) {
            if ($key == 'date') $input[$key] = date_for_database($value);
            if ($key == 'amount') $input[$key] = numberClean($value);
        }

        DB::beginTransaction();

        $banktransfer = Banktransfer::create($input);

        // money transfer accounting
        $banktransfer['bank_transfer_id'] = $banktransfer->id;
        $this->money_transfer_acc($banktransfer);

        if ($banktransfer) {
            DB::commit();
            return $banktransfer;
        }
    }

    /**
     * For updating the respective Model in storage
     *
     * @param Bank $bank
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update(Banktransfer $banktransfer, array $input)
    {
        // dd($input);
        foreach ($input as $key => $value) {
            if ($key == 'date') $input[$key] = date_for_database($value);
            if ($key == 'amount') $input[$key] = numberClean($value);
        }

        DB::beginTransaction();

        $result = $banktransfer->update($input);

        // money transfer accounting
        $banktransfer['bank_transfer_id'] = $banktransfer->id;
        $this->money_transfer_acc($banktransfer, 'update');

        if ($result) {
            DB::commit();
            return $result;
        }
    }

    /**
     * For deleting the respective model from storage
     *
     * @param Bank $bank
     * @throws GeneralException
     * @return bool
     */
    public function delete($banktransfer)
    {
        DB::beginTransaction();

        $this->money_transfer_acc($banktransfer, 'delete');

        if ($banktransfer->delete()) {
            DB::commit();
            return true;
        };
    }
}
