<?php

namespace App\Repositories\Focus\car_model;

use App\Exceptions\GeneralException;
use App\Models\brand\Brand;
use App\Models\car_model\CarModel;
use App\Repositories\BaseRepository;
use Illuminate\Support\Arr;
use DB;

class CarModelRepository extends BaseRepository
{

    const MODEL = CarModel::class;

    public function getForDataTable()
    {
        $q = $this->query();
        return $q->get();
    }

    public function create(array $input)
    {
        DB::beginTransaction();
        $car_model = CarModel::create($input);

        DB::commit();

       if ($car_model) return $car_model;

        throw new GeneralException('Error creating car model.');
    }
    public function update($car_model, array $input)
    {

        DB::beginTransaction();
        $car_model->update($input);

        DB::commit();

       if ($car_model) return $car_model;

        throw new GeneralException('Error updating car model.');
    }

    public function delete($brand)
    {
        // DB::beginTransaction();

        // $brand->delete();
        // DB::commit();

        // throw new GeneralException('Error deleting brand.');
    }
}
