<?php

namespace App\Repositories\Focus\charge;

use App\Models\charge\Charge;
use App\Exceptions\GeneralException;
use App\Models\transaction\Transaction;
use App\Models\transactioncategory\Transactioncategory;
use App\Repositories\BaseRepository;
use App\Repositories\Focus\JournalEntryService;
use Illuminate\Support\Facades\DB;

/**
 * Class ChargeRepository.
 */
class ChargeRepository extends BaseRepository
{
    use JournalEntryService;
    /**
     * Associated Repository Model.
     */
    const MODEL = Charge::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {
        $q = $this->query();

        return $q->get();  
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        // dd($input);
        foreach ($input as $key => $value) {
            if ($key == 'date') $input[$key] = date_for_database($value);
            if ($key == 'amount') $input[$key] = numberClean($value);
        }

        DB::beginTransaction();

        $charge = Charge::create($input);

        // money transfer accounting
        $charge['charge_id'] = $charge->id;
        $this->money_transfer_acc($charge, 'store');

        if ($charge) {
            DB::commit();
            return $charge;
        }
    }

    /**
     * For updating the respective Model in storage
     *
     * @param Charge $charge
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update(Charge $charge, array $input)
    {
        // dd($input);
        foreach ($input as $key => $value) {
            if ($key == 'date') $input[$key] = date_for_database($value);
            if ($key == 'amount') $input[$key] = numberClean($value);
        }

        DB::beginTransaction();

        $result = $charge->update($input);

        // money transfer accounting
        $charge['charge_id'] = $charge->id;
        $this->money_transfer_acc($charge, 'update');

        if ($result) {
            DB::commit();
            return $result;
        }
    }

    /**
     * For deleting the respective model from storage
     *
     * @param Charge $charge
     * @throws GeneralException
     * @return bool
     */
    public function delete(Charge $charge)
    {
        DB::beginTransaction();

        $this->money_transfer_acc($charge, 'delete');

        if ($charge->delete()) {
            DB::commit();
            return true;
        };
    }
}
