<?php

namespace App\Repositories\Focus\jobcard;

use DB;
use Carbon\Carbon;
use App\Models\jobcard\JobCard;
use App\Models\jobcard\JobCardItem;
use App\Models\jobcard\JobCardProcess;
use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use Illuminate\Database\Eloquent\Model;
use App\Utils\MessageUtil;
use Illuminate\Support\Facades\Storage;
use App\Models\jobcard\JobCardAttachment;

/**
 * Class jobcardRepository.
 */
class JobCardRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = JobCard::class;
    protected $file_picture_path;


    /**
     * Constructor.
     */
    public function __construct(MessageUtil $messageUtil)
    {
        $this->file_picture_path = 'img' . DIRECTORY_SEPARATOR . 'jobcard' . DIRECTORY_SEPARATOR;
        $this->storage = Storage::disk('public');
        $this->messageUtil = $messageUtil;
    }

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {

         $q = $this->query();
         $q->when(request('customer_id'), fn($q) => $q->where('customer_id', request('customer_id')));
         $q->when(request('job_status'), fn($q) => $q->where('job_status', request('job_status')));
        //  $q->when(request('project_id'), function($q) {
        //     $q->whereHas('task', fn($q) => $q->where('projects.id', request('project_id')));
        // });
        return  $q->get();
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        // dd($input);
        DB::beginTransaction();
        $data = $input['data'];
        
        foreach ($data as $key => $val) {
            if (in_array($key, ['jobcard_date'])) $data[$key] = date_for_database($val);
            if (in_array($key, ['total_board', 'total_qty', 'no_of_outs', 'no_of_chops', 'length','width','height','die_no','die_cut_outs'])) 
                $data[$key] = numberClean($val);
            
        }
        $result = JobCard::create($data);
        $data_items = $input['data_items'];
        $data_items = array_map(function ($v) use($result) {
            return array_replace($v, [
                'jobcard_id' => $result->id, 
                'ins' => $result->ins,  
            ]);
        }, $data_items);
        JobCardItem::insert($data_items);

        $process_items = $input['process_items'];
        
        $process_items = array_map(function ($v) use($result) {
            return array_replace($v, [
                'jobcard_id' => $result->id, 
                'ins' => $result->ins,  
                'user_id' => auth()->user()->id,  
            ]);
        }, $process_items);
        // dd($process_items);
        JobCardProcess::insert($process_items);

        //Attach Designs
        $design_items = $input['design_items'];
        
        $design_items = array_map(function ($v) use($result) {
            return array_replace($v, [
                'jobcard_id' => $result->id, 
                'ins' => $result->ins,  
                'user_id' => auth()->user()->id,  
            ]);
        }, $design_items);
        // dd($design_items);
        JobCardAttachment::insert($design_items);
        if ($result) {
            DB::commit();
            return $result;
        }
        throw new GeneralException(trans('exceptions.backend.jobcards.create_error'));
    }

    /**
     * For updating the respective Model in storage
     *
     * @param jobcard $jobcard
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update(JobCard $jobcard, array $input)
    {
       // dd($input);
        DB::beginTransaction();
        $data = $input['data'];
        
        foreach ($data as $key => $val) {
            if (in_array($key, ['jobcard_date'])) $data[$key] = date_for_database($val);
            if (in_array($key, ['total_board', 'total_qty', 'no_of_outs', 'no_of_chops', 'length','width','height','die_no','die_cut_outs'])) 
                $data[$key] = numberClean($val);
            
        }
        $result = $jobcard->update($data);

        $data_items = $input['data_items'];
        // remove omitted items
        $item_ids = array_map(function ($v) { return $v['id']; }, $data_items);
        $jobcard->items()->whereNotIn('id', $item_ids)->delete();

        // create or update items
        foreach($data_items as $item) {
            foreach ($item as $key => $val) {
                if (in_array($key, ['meters', 'tones', 'reel_size','gsm_value']))
                    $item[$key] = floatval(str_replace(',', '', $val));
            }
            $jobcard_item = JobCardItem::firstOrNew(['id' => $item['id']]);
            $jobcard_item->fill(array_replace($item, ['jobcard_id' => $jobcard['id'], 'ins' => $jobcard['ins']]));
            if (!$jobcard_item->id) unset($jobcard_item->id);
            $jobcard_item->save();
        }

        $process_items = $input['process_items'];
        //  dd($process_items);
        JobCardProcess::whereNotIn('process_id', $process_items)->where('jobcard_id', $jobcard->id)->whereNotNull('process_id')->delete();
        foreach($process_items as $item) {
            
            JobCardProcess::updateOrCreate(
                ['process_id' => $item['process_id'], 'jobcard_id' => $jobcard->id, 'ins'=> $jobcard->ins],
                ['process_id' => $item['process_id'], 'jobcard_id' => $jobcard->id, 'ins'=> $jobcard->ins]
            );
            //dd($item['process_id']);
        }
        $design_items = $input['design_items'];
        //  dd($design_items);
        JobCardAttachment::whereNotIn('design_id', $design_items)->where('jobcard_id', $jobcard->id)->whereNotNull('design_id')->delete();
        foreach($design_items as $item) {
            
            JobCardAttachment::updateOrCreate(
                ['design_id' => $item['design_id'], 'jobcard_id' => $jobcard->id, 'ins'=> $jobcard->ins],
                ['design_id' => $item['design_id'], 'jobcard_id' => $jobcard->id, 'ins'=> $jobcard->ins]
            );
            //dd($item['design_id']);
        }
        // dd($result);
    	if ($result) {
            DB::commit();
            return $jobcard;      
        }

        throw new GeneralException(trans('exceptions.backend.jobcards.update_error'));
    }

    /**
     * For deleting the respective model from storage
     *
     * @param jobcard $jobcard
     * @throws GeneralException
     * @return bool
     */
    public function delete(JobCard $jobcard)
    {
        if ($jobcard->delete() && $jobcard->items->each->delete()) return true;
        throw new GeneralException('Error deleting JobCard.');
    }

    public function create_design(array $input){

        DB::beginTransaction();

        foreach ($input as $key => $val) {
            if ($key == 'box_design') {
                if (isset($val['design'])) 
                    $input[$key]['design'] = $this->uploadPicture($val['design'], $this->file_picture_path);
                
            }
        }
        // dd($input['box_design']['id']);
        $jobcard = JobCard::find($input['box_design']['id']);
        $jobcard->design = $input['box_design']['design'];
        $result = $jobcard->update();
        if ($result) {
            DB::commit();
            return $jobcard;      
        }

        throw new GeneralException(trans('exceptions.backend.jobcards.update_error'));
    }
    public function create_attachment(array $input){

        DB::beginTransaction();

        foreach ($input as $key => $val) {
            if ($key == 'box_attachment') {
                if (isset($val['attachment'])) 
                    $input[$key]['attachment'] = $this->uploadPicture($val['attachment'], $this->file_picture_path);
                
            }
        }
        //  dd($input['box_attachment']);

        $result = JobCardAttachment::create($input['box_attachment']);
        if ($result) {
            DB::commit();
            return $result;      
        }

        throw new GeneralException(trans('exceptions.backend.jobcards.update_error'));
    }

    /*
    * Upload logo image
    */
    public function uploadPicture($logo, $path)
    {

        $image_name = time() . $logo->getClientOriginalName();

        $this->storage->put($path . $image_name, file_get_contents($logo->getRealPath()));

        return $image_name;
    }
}
