<?php

namespace App\Repositories\Focus\paper;

use DB;
use Carbon\Carbon;
use App\Models\paper\Paper;
use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use Illuminate\Database\Eloquent\Model;

/**
 * Class PaperRepository.
 */
class PaperRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = Paper::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {

        $q =  $this->query();
        $q->when(request('supplier_id'), function($q) {
            $q->where('supplier_id', request('supplier_id'));
        });
        $q->when(request('gsm_id'), function($q) {
            $q->where('gsm_id', request('gsm_id'));
        });
        $q->when(request('paper_width_id'), function($q) {
            $q->where('paper_width_id', request('paper_width_id'));
        });
        return $q->get();
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        // dd($input);
        $input = array_map( 'strip_tags', $input);
        if (Paper::create($input)) {
            return true;
        }
        throw new GeneralException(trans('exceptions.backend.Papers.create_error'));
    }

    /**
     * For updating the respective Model in storage
     *
     * @param Paper $Paper
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update(Paper $paper, array $input)
    {
        // dd($input);
        $input = array_map('strip_tags', $input);
    	if ($paper->update($input))
            return true;

        throw new GeneralException(trans('exceptions.backend.Papers.update_error'));
    }

    /**
     * For deleting the respective model from storage
     *
     * @param Paper $Paper
     * @throws GeneralException
     * @return bool
     */
    public function delete(Paper $paper)
    {
        if ($paper->delete()) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.Papers.delete_error'));
    }
}
