<?php

namespace App\Repositories\Focus\waste_management;

use App\Models\waste_management\WasteManagementItems;
use App\Repositories\BaseRepository;
use DB;
use Carbon\Carbon;


class WasteManagementReportRepository extends BaseRepository
{

    const MODEL = WasteManagementItems::class;

    public function getForDataTable()
    {
        $start_date = empty(request('waste_date'))
        ? null
        : Carbon::parse(request('waste_date'))
          ->startOfDay()
          ->toDateTimeString();

      $end_date = empty(request('waste_date'))
        ? null
        : Carbon::parse(request('waste_date'))
          ->endOfDay()
          ->toDateTimeString();


        $q = $this->query();

        $q->when(request('waste_date'), function($q)use ($start_date, $end_date){
            $q->whereBetween('created_at', [$start_date, $end_date]);
        });
        $q->when(request('station'), function($q){
            $q->where('station_id', request('station'));
        });
        $q->when(request('product'), function($q){
            $q->where('product_id', request('product'));
        });

        return $q->get();
    }
}
