<?php

namespace App\Repositories\Focus\work_order;

use App\Exceptions\GeneralException;
use App\Models\work_order\WorkOrder;
use App\Models\work_order\WorkOrderItem;
use App\Repositories\BaseRepository;
use DB;
use Illuminate\Support\Arr;
use Illuminate\Validation\ValidationException;

class WorkOrderRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = WorkOrder::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {
        $q = $this->query();
        return $q;  
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        // dd($input);
        DB::beginTransaction();

        foreach ($input as $key => $val) {
            if ($key == 'date') $input[$key] = date_for_database($val);
            $keys = ['total', 'subtotal', 'taxable', 'tax', 'tax_rate', 'frx_rate', 'product_qty', 'product_price', 'item_tax_id', 'product_tax', 'product_amount'];
            if (in_array($key, $keys)) {
                if (is_array($val)) $input[$key] = array_map(fn($v) => numberClean($v), $val);
                else $input[$key] = numberClean($val);
            }
        }

        $data = Arr::only($input, [
            'customer_id', 'date', 'tax_rate', 'bank_id', 'validity', 'ledger_id', 'currency_id', 
            'frx_rate', 'term_id', 'note', 'taxable', 'subtotal', 'tax', 'total'
        ]);
        if ($data['frx_rate'] > 1) {
            $data = array_replace($data, [
                'frx_taxable' => round($data['taxable'] * $data['frx_rate'], 4),
                'frx_subtotal' => round($data['subtotal'] * $data['frx_rate'], 4),
                'frx_tax' => round($data['tax'] * $data['frx_rate'], 4),
                'frx_total' => round($data['total'] * $data['frx_rate'], 4),
            ]);
        }
        $data['due_date'] = date_for_database("{$data['date']} + {$data['validity']} days");
        $work_order = WorkOrder::create($data);

        $data_items = Arr::only($input, [
            'numbering', 'description', 'unit', 'product_qty', 'product_price', 'item_tax_id', 'product_tax', 
            'product_amount', 'product_id', 'item_tax_id'
        ]);
        $data_items = modify_array($data_items);
        $data_items = array_filter($data_items, fn($v) => $v['product_qty']);
        if (!$data_items) throw ValidationException::withMessages(['Cannot Invoice without product line items!']);
        $data_items = array_map(function($v) use($work_order) {
            return [
                'work_order_id' => $work_order->id,
                'product_id' => $v['product_id'],
                'num' => $v['numbering'],
                'name' => $v['description'],
                'qty' => $v['product_qty'],
                'subtotal' => $v['product_price'],
                'tax' => $v['product_tax'],
                'total' => $v['product_amount'],
                'tax_rate' => $v['item_tax_id'],
                'uom' => $v['unit'],
            ];
        }, $data_items);
        WorkOrderItem::insert($data_items);

        if ($work_order) {
            DB::commit();
            return $work_order;
        }
    }

    /**
     * For updating the respective Model in storage
     *
     * @param Invoice $invoice
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update(Invoice $invoice, array $input)
    {
        dd($input);

        throw new GeneralException(trans('exceptions.backend.charges.update_error'));
    }

    /**
     * For deleting the respective model from storage
     *
     * @param Invoice $invoice
     * @throws GeneralException
     * @return bool
     */
    public function delete(Invoice $invoice)
    {
        dd($invoice);     

        throw new GeneralException(trans('exceptions.backend.charges.delete_error'));
    }
}
