<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWareHouseRowsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ware_house_rows', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('ware_house_id');
            $table->foreign('ware_house_id')->references('id')->on('warehouses');
            $table->string('row_number');
            $table->longText('extra')->nullable();
            $table->unsignedBigInteger('ins');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ware_house_rows');
    }
}
