<div class="tab-pane  active in" id="tab_data1" aria-labelledby="tab1" role="tabpanel">
    <div class="card">
        <div class="card-head">
            <div class="card-header">
                <h4 class="card-title">{{ gen4tid('Prj-', $project->tid) }} ; {{ $project['name'] }}</h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            </div>
            <div class="px-1">
                <p>{{ $project['short_desc'] }}</p>
                <div class="heading-elements">
                    @foreach ($project->tags as $row)
                        <span class="badge" style="background-color:{{ $row['color'] }}">{{ $row['name'] }}</span>
                    @endforeach
                </div>
                <ul class="list-inline list-inline-pipe text-center p-1 border-bottom-grey border-bottom-lighten-3 h5">
                    <li>{{ trans('projects.owner') }}: 
                        {{-- <span class="text-muted text-bold-600 blue">{{ $project->creator->first_name . ' ' . $project->creator->last_name }}</span> --}}
                    </li>
                    <li>{{ trans('customers.customer') }}: 
                        <span class="text-bold-600 primary">
                            <a href="{{ route('biller.customers.show', $project->customer) }}">
                                {{ $project->customer->company }}
                            </a>
                        </span>                               
                    </li>
                    
                </ul>
                <ul class="list-inline list-inline-pipe text-center p-1 border-bottom-grey border-bottom-lighten-3 h5">
                    <li>{{ trans('projects.start_date') }}: 
                        <span class=" text-bold-600 purple">{{ dateTimeFormat($project['start_date']) }}</span>
                    </li>
                    <li>{{ trans('projects.end_date') }}: 
                        <span class="text-bold-600 danger">{{ dateTimeFormat($project['end_date']) }}</span>
                    </li>
                </ul>
                <ul class="list-inline list-inline-pipe text-center border-bottom-grey border-bottom-lighten-3 h5">
                    <li>Project Ended By: 
                        <span class=" text-bold-600 purple">{{ $project->user? $project->user->full_name : ''  }}</span>
                    </li>
                </ul>
                @if ($project->end_note)
                    <ul class="list-inline list-inline-pipe text-center border-bottom-grey border-bottom-lighten-3 h5">
                        <li>Project End Note: 
                            <span class=" text-bold-600 purple">{{ $project->name}}</span>
                        </li>
                    </ul>    
                @endif
            </div>
        </div>
        <!-- project-info -->
        <div class="card-body">
            <div class="card-subtitle line-on-side text-muted text-center font-small-3 mx-2 my-1">
                <span>{{ trans('projects.eagle_view') }}</span>
            </div>
        </div>
    </div>
    <section class="row">
        <div class="col-xl-12 col-lg-12 col-md-12">
            <!-- Project Overview -->
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{ trans('general.description') }}</h4>
                    <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                    <div class="heading-elements">
                        <ul class="list-inline mb-0">
                            <li><a data-action="collapse"><i class="ft-minus"></i></a></li>
                            <li><a data-action="close"><i class="ft-x"></i></a></li>
                        </ul>
                    </div>
                </div>
                <div class="card-content collapse show">
                    <div class="card-body">
                        {{ $project->description }}
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
