<script>
    const config = {
       ajax: {
           headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}
       },
       select: {
           allowClear: true,
       },
       date: {autoHide: true, format: '{{config('core.user_date_format')}}'},
   };
   // ajax header set up
   $.ajaxSetup(config.ajax);


   $(() =>{
       // on show tab load datatables
       $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
           localStorage.setItem('project_tab', $(e.target).attr('href'));
           switch ($(e.target).attr('href')) {
              
               case '#tab_data2': jobcard(); break;
               case '#tab_data3': dispatch(); break;
               case '#tab_data4': jobSum(); break;
               case '#tab_data5': attachment(); break;
               
           }
       });
       const projectTab = localStorage.project_tab;
       if (projectTab) $('a[href="' + projectTab + '"]').tab('show');
   });
   function jobcard() {
       if ($('#jobcardTbl tbody tr').length) return;        
       $('#jobcardTbl').dataTable({
           processing: true,
           responsive: true,
           stateSave: true,
           language: {@lang('datatable.strings')},
           ajax: {
               url: "{{ route('biller.jobcards.get_jobcards') }}",
               type: 'POST',
               data: {project_id: "{{ $project->id }}"},
           },
           columns: [
               {data: 'DT_Row_Index',name: 'id'},
               ...['jobcard_no','description', 'total_board', 'total_qty']
               .map(v => ({data: v, name: v})),
               {data: 'net_qty', name: 'net_qty', searchable: false, sortable: false}
           ],
           order:[[0, 'desc']],
           searchDelay: 500,
           dom: 'Blfrtip',
           buttons: ['csv', 'excel', 'print'],
       });
   } 

   function attachment() {
        if ($('#attachmentsTbl tbody tr').length) return;        
        $('#attachmentsTbl').dataTable({
            processing: true,
            responsive: true,
            stateSave: true,
            language: {@lang('datatable.strings')},
            ajax: {
                url: "{{ route('biller.jobcards.get_attachment') }}",
                type: 'POST',
                data: {project_id: "{{ $project->id }}"},
            },
            columns: [
                {data: 'DT_Row_Index',name: 'id'},
                ...['jobcard_no', 'attachment']
                .map(v => ({data: v, name: v})),
                // {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ],
            order:[[0, 'desc']],
            searchDelay: 500,
            dom: 'Blfrtip',
            buttons: ['csv', 'excel', 'print'],
        });
    } 
   function dispatch() {
       if ($('#dispatchTbl tbody tr').length) return;        
       $('#dispatchTbl').dataTable({
           processing: true,
           responsive: true,
           stateSave: true,
           language: {@lang('datatable.strings')},
           ajax: {
               url: "{{ route('biller.jobcards.get_dispatch') }}",
               type: 'POST',
               data: {project_id: "{{ $project->id }}"},
           },
           columns: [
               {data: 'DT_Row_Index',name: 'id'},
               ...[]
               .map(v => ({data: v, name: v})),
               {data: 'operator_sign', name: 'operator_sign', searchable: false, sortable: false}
           ],
           order:[[0, 'desc']],
           searchDelay: 500,
           dom: 'Blfrtip',
           buttons: ['csv', 'excel', 'print'],
       });
   } 

  
   function jobSum() {
       if ($('#jobSumTbl tbody tr').length) return;        
       $('#jobSumTbl').dataTable({
           processing: true,
           responsive: true,
           stateSave: true,
           language: {@lang('datatable.strings')},
           ajax: {
               url: "{{ route('biller.jobcards.get_job_summary') }}",
               type: 'POST',
               data: {project_id: "{{ $project->id }}"},
           },
           columns: [
               {data: 'DT_Row_Index',name: 'id'},
               ...['jobcard_no','total_per_jobcard','project_qty_needed']
               .map(v => ({data: v, name: v})),
               {data: 'total_dispatch', name: 'total_dispatch', searchable: false, sortable: false}
           ],
           order:[[0, 'desc']],
           searchDelay: 500,
           dom: 'Blfrtip',
           buttons: ['csv', 'excel', 'print'],
       });
   }


</script>