@extends ('core.layouts.app')

@section ('title', 'Assembled Products')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Assembled Products</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">

                    @include('focus.assembly.assembled_product.partials.assembled-products-header-buttons')
                </div>
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-3">
                                <label for="date" class="h4">Date</label>
                                {{ Form::date('assembly_date', null ,['class' => 'form-control', 'id' => 'assembly_date', '']) }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <table id="assembledProducts" class="table table-striped table-bordered zero-configuration" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Entry No</th>
                                    <th>Date</th>
                                    <th>{{ trans('labels.general.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="100%" class="text-center text-success font-large-1">
                                        <i class="fa fa-spinner spinner"></i>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('after-scripts')
{{ Html::script(mix('js/dataTable.js')) }}
{{ Html::script('focus/js/select2.min.js') }}
<script>
    const config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}" }}
    };

    const Index = {
        assemblyDateId: @json(request('assembly_date')),

        init() {
            this.drawDataTable();
            $('#assembly_date').val(this.assemblyDateId).change(this.assemblyDateChange);
        },

        assemblyDateChange() {
            Index.assemblyDateId = $(this).val();
            $('#assembledProducts').DataTable().destroy();
            return Index.drawDataTable();
        },
        drawDataTable() {
            $('#assembledProducts').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                stateSave: true,
                language: {@lang('datatable.strings')},
                ajax: {
                    url: '{{ route("biller.assembled_products.get") }}',
                    type: 'post',
                    data: {
                        assemble_date: this.assemblyDateId,
                    },
                },
                columns: [
                {data: 'DT_Row_Index', name: 'id'},
                {data: 'tid', name: 'tid'},
                {data: 'date', name: 'date'},
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ],
                order: [[0, "desc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print']
            });
        },
    };

    $(() => Index.init());
</script>
@endsection
