@extends ('core.layouts.app')
@section('title', 'Assembled Materials')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-2">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Assembled Materials</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.assembly.assembled_product.partials.assembled-products-header-buttons')
                </div>
            </div>
        </div>
    </div>
    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-header">
                            <h4 class="card-title">
                                <div class="container">
                                    {{ trans('products.general_product_details') }}
                                    <a href="{{ route('biller.assembled-proucts.edit', [$assembled_products['id']]) }}" class="btn btn-blue btn-outline-accent-5 btn-sm float-right">
                                        <i class="fa fa-pencil"></i> {{ trans('buttons.general.crud.edit') }}
                                    </a>

                                    {{-- <a href="{{ route('biller.material-issuing.print', [$assembled_products['id']]) }}" class="btn btn-blue btn-outline-accent-5 btn-sm float-right">
                                        <i class="fa fa-print"></i> Print
                                    </a> --}}
                                </div>

                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="container">
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                       Entry No:</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$assembled_products->tid}}
                                    </div>
                                </div>

                                {{-- <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Items Issued</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$material_issuing->material_issuing_items->count()}}

                                    </div>
                                </div> --}}
                                {{-- <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Total Amount</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$material_issuing->amount}}
                                    </div>
                                </div> --}}
                                {{-- <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Warehouse</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$material_issuing->warehouse_station->title}}
                                    </div>
                                </div> --}}
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Date</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{date('d-m-y', strtotime($assembled_products->assemble_date))}}
                                    </div>
                                </div>
                                {{-- <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Issued To(Edit)</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$material_issuing->assembly_station->name}}
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Issued By</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$material_issuing->issued_by->first_name}} {{$material_issuing->issued_by->last_name}}
                                    </div>
                                </div> --}}
                            </div>


                            <div class="container">
                                <br><br>
                                <div class="content-header-left col-6">
                                    <h4 class="content-header-title">Assembled Products</h4>
                                </div>
                                <br><br>
                                <table class="table table-bordered">
                                    <thead>
                                        <th>#</th>
                                        <th>Product</th>
                                        <th>Initial Qty</th>
                                        <th>Assembled Qty</th>
                                        <th>Final Qty</th>
                                        <th>UoM</th>
                                        {{-- <th>Unit Cost</th> --}}
                                        {{-- <th>Total Cost</th> --}}
                                    </thead>
                                    <tbody>
                                        @foreach ( $assembled_products['assembled_product_items'] as $mi)
                                            <tr>
                                                <td>{{$loop->iteration}}</td>
                                                <td>{{$mi->product->name}}</td>
                                                <td>{{$mi->current_stock_quantity}}</td>
                                                <td>{{$mi->assembled_quantity}}</td>
                                                <td>{{$mi->assembled_quantity + $mi->current_stock_quantity}}</td>
                                                <td>{{$mi->unit_of_measure->title}}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

